package com.contentsquare.android.internal.validator;


import android.support.annotation.NonNull;

import com.contentsquare.android.internal.config.GodModeConfiguration;

/**
 * This class will check the {@link com.contentsquare.android.internal.config.GodModeConfiguration}
 * values and validate them.
 * <p>
 * First the god_mode Json flag will be checked and then the
 * {@link com.contentsquare.android.internal.Session#getProjectId()} will be checked into the
 * {@code whitelist} Json String array.
 */

public class GodModeConfigValidator {

    /**
     * Tells if the god mode is enabled for the provided {@link GodModeConfiguration} and projectId
     * as the application package name.
     *
     * @param projectId     as {@link String}
     * @param configuration as {@link GodModeConfiguration}
     * @return true if the God mode is enabled for this project id.
     */
    public boolean isGodModeValidFor(@NonNull String projectId,
                                     @NonNull GodModeConfiguration configuration) {

        if (configuration.isGodModeEnabled()) {
            final String whiteList = configuration.getWhiteList();
            return (whiteList != null && whiteList.contains(projectId));
        }
        return false;
    }

}
