/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.protocol;

import com.corundumstudio.socketio.AckCallback;
import com.corundumstudio.socketio.ack.AckManager;
import com.corundumstudio.socketio.protocol.AckArgs;
import com.corundumstudio.socketio.protocol.Event;
import com.corundumstudio.socketio.protocol.JsonSupport;
import com.corundumstudio.socketio.protocol.Packet;
import com.corundumstudio.socketio.protocol.PacketType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufProcessor;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.UUID;

public class PacketDecoder {
    private final JsonSupport jsonSupport;
    private final AckManager ackManager;

    public PacketDecoder(JsonSupport jsonSupport, AckManager ackManager) {
        this.jsonSupport = jsonSupport;
        this.ackManager = ackManager;
    }

    public ByteBuf preprocessJson(Integer jsonIndex, ByteBuf content) throws IOException {
        String packet = URLDecoder.decode(content.toString(CharsetUtil.UTF_8), CharsetUtil.UTF_8.name());
        if (jsonIndex != null) {
            packet = packet.substring(2);
        }
        int splitIndex = packet.indexOf(":");
        String len = packet.substring(0, splitIndex);
        Integer length = Integer.valueOf(len);
        packet = packet.substring(splitIndex + 1, splitIndex + length + 1);
        packet = new String(packet.getBytes(CharsetUtil.ISO_8859_1), CharsetUtil.UTF_8);
        return Unpooled.wrappedBuffer((byte[])packet.getBytes(CharsetUtil.UTF_8));
    }

    private long parseLong(ByteBuf chars, int length) {
        long result = 0L;
        for (int i = chars.readerIndex(); i < chars.readerIndex() + length; ++i) {
            int digit = chars.getByte(i) & 0xF;
            for (int j = 0; j < chars.readerIndex() + length - 1 - i; ++j) {
                digit *= 10;
            }
            result += (long)digit;
        }
        return result;
    }

    private PacketType readType(ByteBuf buffer) {
        int typeId = buffer.readByte() & 0xF;
        return PacketType.valueOf(typeId);
    }

    private PacketType readInnerType(ByteBuf buffer) {
        int typeId = buffer.readByte() & 0xF;
        return PacketType.valueOfInner(typeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Packet decodePacket(String string, UUID uuid) throws IOException {
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)string, (Charset)CharsetUtil.UTF_8);
        try {
            Packet packet = null;
            return packet;
        }
        finally {
            buf.release();
        }
    }

    private static int find(ByteBuf buffer, final char item) {
        int index = buffer.forEachByte(buffer.readerIndex(), buffer.readableBytes(), new ByteBufProcessor(){

            public boolean process(byte value) throws Exception {
                return value != item;
            }
        });
        return index;
    }

    public Packet decodePackets(ByteBuf buffer, UUID uuid) throws IOException {
        boolean isString;
        boolean bl = isString = buffer.getByte(buffer.readerIndex()) == 0;
        if (isString) {
            int headEndIndex = buffer.bytesBefore((byte)-1);
            int len = (int)this.parseLong(buffer, headEndIndex);
            buffer.readerIndex(buffer.readerIndex() + headEndIndex);
            ByteBuf frame = buffer.slice(buffer.readerIndex() + 1, len);
            buffer.readerIndex(buffer.readerIndex() + 1 + len);
            return this.decode(uuid, frame);
        }
        return this.decode(uuid, buffer);
    }

    private String readString(ByteBuf frame) {
        return this.readString(frame, frame.readableBytes());
    }

    private String readString(ByteBuf frame, int size) {
        byte[] bytes = new byte[size];
        frame.readBytes(bytes);
        return new String(bytes, CharsetUtil.UTF_8);
    }

    private Packet decode(UUID uuid, ByteBuf frame) throws IOException {
        PacketType type = this.readType(frame);
        Packet packet = new Packet(type);
        if (type == PacketType.PING) {
            packet.setData(this.readString(frame));
            return packet;
        }
        if (!frame.isReadable()) {
            return packet;
        }
        PacketType innerType = this.readInnerType(frame);
        packet.setSubType(innerType);
        int endIndex = PacketDecoder.find(frame, '[');
        if (endIndex > frame.readerIndex()) {
            String nspAckId = this.readString(frame, endIndex - frame.readerIndex());
            if (nspAckId.contains(",")) {
                String[] parts = nspAckId.split(",");
                String nsp = parts[0];
                packet.setNsp(nsp);
                if (parts.length > 1) {
                    String ackId = parts[1];
                    packet.setAckId(Long.valueOf(ackId));
                }
            } else {
                packet.setAckId(Long.valueOf(nspAckId));
            }
        }
        if (packet.getType() == PacketType.MESSAGE) {
            ByteBufInputStream in;
            if (packet.getSubType() == PacketType.CONNECT || packet.getSubType() == PacketType.DISCONNECT) {
                packet.setNsp(this.readString(frame));
            }
            if (packet.getSubType() == PacketType.ACK) {
                in = new ByteBufInputStream(frame);
                AckCallback<?> callback = this.ackManager.getCallback(uuid, packet.getAckId());
                AckArgs args = this.jsonSupport.readAckArgs(in, callback);
                packet.setData(args.getArgs());
            }
            if (packet.getSubType() == PacketType.EVENT || packet.getSubType() == PacketType.BINARY_EVENT) {
                in = new ByteBufInputStream(frame);
                Event event = this.jsonSupport.readValue(in, Event.class);
                packet.setName(event.getName());
                packet.setData(event.getArgs());
            }
        }
        return packet;
    }
}

