/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.protocol;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.protocol.JsonSupport;
import com.corundumstudio.socketio.protocol.Packet;
import com.corundumstudio.socketio.protocol.PacketType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.regex.Pattern;

public class PacketEncoder {
    private static final Pattern QUOTES_PATTERN = Pattern.compile("\"", 16);
    private static final byte[] B64_DELIMITER = new byte[]{58};
    private static final byte[] JSONP_HEAD = "___eio[".getBytes(CharsetUtil.UTF_8);
    private static final byte[] JSONP_START = "](\"".getBytes(CharsetUtil.UTF_8);
    private static final byte[] JSONP_END = "\");".getBytes(CharsetUtil.UTF_8);
    private final JsonSupport jsonSupport;
    private final Configuration configuration;
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};

    public PacketEncoder(Configuration configuration, JsonSupport jsonSupport) {
        this.jsonSupport = jsonSupport;
        this.configuration = configuration;
    }

    public ByteBuf allocateBuffer(ByteBufAllocator allocator) {
        if (this.configuration.isPreferDirectBuffer()) {
            return allocator.ioBuffer();
        }
        return allocator.heapBuffer();
    }

    public void encodeJsonP(Integer jsonpIndex, Queue<Packet> packets, ByteBuf out, ByteBufAllocator allocator, int limit) throws IOException {
        Object packet;
        boolean jsonpMode = jsonpIndex != null;
        ByteBuf buf = out;
        if (jsonpMode) {
            buf = this.allocateBuffer(allocator);
        }
        for (int i = 0; (packet = packets.poll()) != null && i != limit; ++i) {
            ByteBuf packetBuf = this.allocateBuffer(allocator);
            this.encodePacket((Packet)packet, packetBuf, allocator, true, jsonpMode);
            int packetSize = packetBuf.writerIndex();
            if (jsonpMode) {
                int count = this.count(packetBuf, Unpooled.copiedBuffer((CharSequence)"\\\"", (Charset)CharsetUtil.UTF_8));
                packetSize -= count;
            }
            buf.writeBytes(PacketEncoder.toChars(packetSize));
            buf.writeBytes(B64_DELIMITER);
            buf.writeBytes(packetBuf);
        }
        if (jsonpMode) {
            out.writeBytes(JSONP_HEAD);
            out.writeBytes(PacketEncoder.toChars(jsonpIndex.intValue()));
            out.writeBytes(JSONP_START);
            packet = buf.toString(CharsetUtil.UTF_8);
            buf.release();
            packet = QUOTES_PATTERN.matcher((CharSequence)packet).replaceAll("\\\\\"");
            packet = new String(((String)packet).getBytes(CharsetUtil.UTF_8), CharsetUtil.ISO_8859_1);
            out.writeBytes(((String)packet).getBytes(CharsetUtil.UTF_8));
            out.writeBytes(JSONP_END);
        }
    }

    public void encodePackets(Queue<Packet> packets, ByteBuf buffer, ByteBufAllocator allocator, int limit) throws IOException {
        Packet packet;
        for (int i = 0; (packet = packets.poll()) != null && i != limit; ++i) {
            this.encodePacket(packet, buffer, allocator, false, false);
        }
    }

    private byte toChar(int number) {
        return (byte)(number ^ 0x30);
    }

    static int stringSize(long x) {
        int i = 0;
        while (x > (long)sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    static void getChars(long i, int index, byte[] buf) {
        long r;
        long q;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536L) {
            q = i / 100L;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--charPos] = (byte)DigitOnes[(int)r];
            buf[--charPos] = (byte)DigitTens[(int)r];
        }
        do {
            q = i * 52429L >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = (byte)digits[(int)r];
        } while ((i = q) != 0L);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    public static byte[] toChars(long i) {
        int size = i < 0L ? PacketEncoder.stringSize(-i) + 1 : PacketEncoder.stringSize(i);
        byte[] buf = new byte[size];
        PacketEncoder.getChars(i, size, buf);
        return buf;
    }

    public static byte[] longToBytes(long number) {
        int length = (int)(Math.log10(number) + 1.0);
        byte[] res = new byte[length];
        int i = length;
        while (number > 0L) {
            res[--i] = (byte)(number % 10L);
            number /= 10L;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodePacket(Packet packet, ByteBuf buffer, ByteBufAllocator allocator, boolean binary, boolean jsonp) throws IOException {
        ByteBuf buf = buffer;
        if (!binary) {
            buf = this.allocateBuffer(allocator);
        }
        byte type = this.toChar(packet.getType().getValue());
        buf.writeByte((int)type);
        switch (packet.getType()) {
            case PONG: {
                buf.writeBytes(packet.getData().toString().getBytes(CharsetUtil.UTF_8));
                break;
            }
            case OPEN: {
                ByteBufOutputStream out = new ByteBufOutputStream(buf);
                if (jsonp) {
                    this.jsonSupport.writeJsonpValue(out, packet.getData());
                    break;
                }
                this.jsonSupport.writeValue(out, packet.getData());
                break;
            }
            case MESSAGE: {
                byte subType = this.toChar(packet.getSubType().getValue());
                buf.writeByte((int)subType);
                if (packet.getSubType() == PacketType.CONNECT) {
                    if (!packet.getNsp().isEmpty()) {
                        buf.writeBytes(packet.getNsp().getBytes(CharsetUtil.UTF_8));
                    }
                } else if (!packet.getNsp().isEmpty()) {
                    buf.writeBytes(packet.getNsp().getBytes(CharsetUtil.UTF_8));
                    buf.writeBytes(new byte[]{44});
                }
                if (packet.getAckId() != null) {
                    byte[] ackId = PacketEncoder.toChars(packet.getAckId());
                    buf.writeBytes(ackId);
                }
                ArrayList<String> values = new ArrayList<String>();
                if (packet.getSubType() == PacketType.EVENT || packet.getSubType() == PacketType.ERROR) {
                    values.add(packet.getName());
                }
                if (packet.getSubType() != PacketType.EVENT && packet.getSubType() != PacketType.ACK && packet.getSubType() != PacketType.ERROR) break;
                List args = (List)packet.getData();
                values.addAll(args);
                ByteBufOutputStream out = new ByteBufOutputStream(buf);
                if (jsonp) {
                    this.jsonSupport.writeJsonpValue(out, values);
                    break;
                }
                if (binary) {
                    ByteBuf b = this.allocateBuffer(allocator);
                    try {
                        ByteBufOutputStream os = new ByteBufOutputStream(b);
                        this.jsonSupport.writeValue(os, values);
                        CharsetEncoder enc = CharsetUtil.ISO_8859_1.newEncoder();
                        String str = b.toString(CharsetUtil.ISO_8859_1);
                        if (enc.canEncode(str)) {
                            buf.writeBytes(str.getBytes(CharsetUtil.UTF_8));
                            break;
                        }
                        buf.writeBytes(b);
                        break;
                    }
                    finally {
                        b.release();
                    }
                }
                this.jsonSupport.writeValue(out, values);
                break;
            }
        }
        if (!binary) {
            buffer.writeByte(0);
            int length = buf.writerIndex();
            buffer.writeBytes(PacketEncoder.longToBytes(length));
            buffer.writeByte(255);
            buffer.writeBytes(buf);
        }
    }

    private int count(ByteBuf buffer, ByteBuf searchValue) {
        int count = 0;
        for (int i = 0; i < buffer.readableBytes(); ++i) {
            if (!this.isValueFound(buffer, i, searchValue)) continue;
            ++count;
        }
        return count;
    }

    private boolean isValueFound(ByteBuf buffer, int index, ByteBuf search) {
        for (int i = 0; i < search.readableBytes(); ++i) {
            if (buffer.getByte(index + i) == search.getByte(i)) continue;
            return false;
        }
        return true;
    }
}

