/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.spring.cache;

import com.couchbase.client.spring.cache.CacheBuilder;
import com.couchbase.client.spring.cache.CouchbaseCache;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractCacheManager;

public class CouchbaseCacheManager
extends AbstractCacheManager {
    private CacheBuilder defaultCacheBuilder;
    private boolean initialized;
    private final Map<String, CacheBuilder> initialCaches;

    public CouchbaseCacheManager(CacheBuilder cacheBuilder, String ... cacheNames) {
        if (cacheBuilder == null) {
            throw new NullPointerException("CacheBuilder template is mandatory");
        }
        LinkedHashSet<String> names = cacheNames.length == 0 ? Collections.emptySet() : new LinkedHashSet<String>(Arrays.asList(cacheNames));
        this.initialCaches = new HashMap<String, CacheBuilder>(names.size());
        for (String name : names) {
            if (name == null) continue;
            this.initialCaches.put(name, cacheBuilder);
        }
        if (this.initialCaches.isEmpty()) {
            this.defaultCacheBuilder = cacheBuilder;
        }
    }

    public CouchbaseCacheManager(Map<String, CacheBuilder> initialCaches) {
        if (initialCaches == null || initialCaches.isEmpty()) {
            throw new IllegalArgumentException("At least one cache builder must be specified.");
        }
        this.initialCaches = new HashMap<String, CacheBuilder>(initialCaches);
    }

    public void setDefaultCacheBuilder(CacheBuilder defaultCacheBuilder) {
        this.defaultCacheBuilder = defaultCacheBuilder;
    }

    public void prepareCache(String name) {
        if (this.defaultCacheBuilder == null) {
            throw new IllegalStateException("No default cache builder is specified.");
        }
        this.prepareCache(name, this.defaultCacheBuilder);
    }

    public void prepareCache(String name, CacheBuilder builder) {
        if (this.initialized) {
            throw new IllegalStateException("This cache manager has already been initialized. No further cache can be prepared.");
        }
        this.initialCaches.put(name, builder);
    }

    protected Cache getMissingCache(String name) {
        return this.defaultCacheBuilder != null ? this.defaultCacheBuilder.build(name) : null;
    }

    protected final Collection<? extends Cache> loadCaches() {
        this.initialized = true;
        LinkedList<CouchbaseCache> caches = new LinkedList<CouchbaseCache>();
        for (Map.Entry<String, CacheBuilder> entry : this.initialCaches.entrySet()) {
            caches.add(entry.getValue().build(entry.getKey()));
        }
        return caches;
    }
}

