/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.server;

import com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.lite.internal.storage.JobNodePath;
import java.util.regex.Pattern;

public final class ServerNode {
    public static final String ROOT = "servers";
    private static final String SERVERS = "servers/%s";
    private final String jobName;
    private final JobNodePath jobNodePath;

    public ServerNode(String jobName) {
        this.jobName = jobName;
        this.jobNodePath = new JobNodePath(jobName);
    }

    public boolean isServerPath(String path) {
        return Pattern.compile(this.jobNodePath.getFullPath(ROOT) + "/" + "((\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3})").matcher(path).matches();
    }

    public boolean isLocalServerPath(String path) {
        return path.equals(this.jobNodePath.getFullPath(String.format(SERVERS, JobRegistry.getInstance().getJobInstance(this.jobName).getIp())));
    }

    String getServerNode(String ip) {
        return String.format(SERVERS, ip);
    }
}

