/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.deeptestutils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import org.objenesis.ObjenesisStd;

public final class Reflector {
    private static HashMap<String, Class<?>> classMap = new HashMap();

    private Reflector() {
    }

    public static void setField(Object obj, String fieldName, Object newVal) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Reflector.setField(obj.getClass(), obj, fieldName, newVal);
    }

    private static <T> void setField(Class<T> c, Object o, String fieldName, Object newVal) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (c == null) {
            throw new NoSuchFieldException();
        }
        Optional<Field> field = Arrays.stream(c.getDeclaredFields()).filter(f -> f.getName().equals(fieldName)).findAny();
        if (!field.isPresent()) {
            Reflector.setField(c.getSuperclass(), o, fieldName, newVal);
        } else {
            Field property = field.get();
            property.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(property, property.getModifiers() & 0xFFFFFFEF);
            try {
                property.set(o, newVal);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static <T> Object getInstanceField(Class<T> c, Object o, String fieldName) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (c == null) {
            throw new NoSuchFieldException();
        }
        Optional<Field> field = Arrays.stream(c.getDeclaredFields()).filter(f -> f.getName().equals(fieldName)).findAny();
        if (!field.isPresent()) {
            return Reflector.getInstanceField(c.getSuperclass(), o, fieldName);
        }
        Field property = field.get();
        property.setAccessible(true);
        try {
            return property.get(o);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object getInstanceField(Object obj, String fieldName) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        return Reflector.getInstanceField(obj.getClass(), obj, fieldName);
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        String cleanedName = className.replaceAll("\\s+", "");
        if (cleanedName.endsWith("[]")) {
            String arrayPrefix = "";
            while (cleanedName.endsWith("[]")) {
                int parenthesisIndex = cleanedName.length() - 2;
                arrayPrefix = arrayPrefix + "[";
                cleanedName = cleanedName.substring(0, parenthesisIndex);
            }
            cleanedName = cleanedName.equals("float") ? "F" : (cleanedName.equals("byte") ? "B" : (cleanedName.equals("char") ? "C" : (cleanedName.equals("short") ? "S" : (cleanedName.equals("double") ? "D" : (cleanedName.equals("int") ? "I" : (cleanedName.equals("long") ? "J" : (cleanedName.equals("boolean") ? "Z" : "L" + cleanedName + ";")))))));
            return Class.forName(arrayPrefix + cleanedName);
        }
        return Class.forName(className);
    }

    public static Class<? extends Throwable> toThrowableClass(String className) throws ClassCastException, ClassNotFoundException {
        Class<Throwable> throwableClass = Throwable.class;
        Class<Throwable> cl = Reflector.forName(className);
        if (cl.isAssignableFrom(throwableClass)) {
            return cl;
        }
        throw new ClassCastException("cannot cast " + className + " to Throwable");
    }

    public static String removePackageFromName(String className) {
        int lastSeparator = className.lastIndexOf(46);
        if (lastSeparator != -1) {
            return className.substring(lastSeparator + 1);
        }
        return className;
    }

    private static void makePublic(CtMember m) {
        int modifier = m.getModifiers();
        modifier &= 0xFFFFFFF9;
        m.setModifiers(modifier |= 1);
    }

    private static void makePublic(CtClass c) {
        int modifier = c.getModifiers();
        modifier &= 0xFFFFFFF9;
        c.setModifiers(modifier |= 1);
    }

    public static <T> T getInstance(Class<T> cl) {
        Optional<Constructor<?>> ctor = Reflector.getDefaultConstructor(cl);
        if (ctor.isPresent()) {
            Constructor<?> defaultCtor = ctor.get();
            defaultCtor.setAccessible(true);
            try {
                return (T)defaultCtor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                return (T)new ObjenesisStd().newInstance(cl);
            }
        }
        return (T)new ObjenesisStd().newInstance(cl);
    }

    public static <T> Object getInstance(String className) throws ClassNotFoundException, NotFoundException, CannotCompileException, InstantiationException, IllegalAccessException, BadBytecode {
        ClassPool pool = ClassPool.getDefault();
        CtClass cl = pool.get(className);
        for (CtMethod ctMethod : cl.getDeclaredMethods()) {
            Reflector.makePublic((CtMember)ctMethod);
        }
        for (CtMethod ctMethod : cl.getDeclaredConstructors()) {
            Reflector.makePublic((CtMember)ctMethod);
        }
        for (CtMethod ctMethod : cl.getDeclaredFields()) {
            Reflector.makePublic((CtMember)ctMethod);
        }
        Reflector.makePublic(cl);
        if (Reflector.isAbstract(cl) || cl.isInterface()) {
            String packageName = "com.diffblue.test_gen.";
            String newClassName = packageName + Reflector.removePackageFromName(className);
            CtClass implementation = pool.getOrNull(newClassName + "_implementation");
            if (implementation == null) {
                boolean bl;
                implementation = pool.makeClass(newClassName + "_implementation");
                if (cl.isInterface()) {
                    implementation.setInterfaces(new CtClass[]{cl});
                } else {
                    implementation.setSuperclass(cl);
                }
                boolean bl2 = false;
                if (!cl.isInterface()) {
                    for (CtConstructor ctor : cl.getConstructors()) {
                        if (ctor.getParameterTypes().length != 0 || (ctor.getModifiers() & 0x400) != 0 || ctor.isEmpty()) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    CtConstructor newCtor = new CtConstructor(new CtClass[0], implementation);
                    newCtor.setBody("{}");
                    implementation.addConstructor(newCtor);
                }
                for (CtConstructor m : cl.getDeclaredMethods()) {
                    if (!Reflector.isAbstract((CtMethod)m)) continue;
                    CtMethod method = CtNewMethod.make((int)1, (CtClass)m.getReturnType(), (String)m.getName(), (CtClass[])m.getParameterTypes(), (CtClass[])m.getExceptionTypes(), null, (CtClass)implementation);
                    implementation.addMethod(method);
                }
                Class ic = pool.toClass(implementation);
                classMap.put(newClassName + "_implementation", ic);
                return Reflector.getInstance(ic);
            }
            return Reflector.getInstance(classMap.get(newClassName + "_implementation"));
        }
        return Reflector.getInstance(Class.forName(className));
    }

    private static boolean isAbstract(CtMethod m) {
        return (m.getModifiers() & 0x400) != 0;
    }

    private static boolean isAbstract(CtClass c) {
        if ((c.getModifiers() & 0x400) != 0) {
            return true;
        }
        for (CtMethod m : c.getDeclaredMethods()) {
            if (!Reflector.isAbstract(m)) continue;
            return true;
        }
        return false;
    }

    private static Optional<Constructor<?>> getDefaultConstructor(Class<?> c) {
        return Arrays.stream(c.getDeclaredConstructors()).filter(ctor -> ctor.getParameterCount() == 0).findAny();
    }
}

