/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.utils;

import com.centit.fileserver.utils.FileStore;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileMD5Maker;
import com.centit.support.file.FileSystemOpt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class OsFileStore
implements FileStore {
    private String fileRoot;

    public OsFileStore() {
    }

    public OsFileStore(String fileRoot) {
        this.setFileRoot(fileRoot);
    }

    public void setFileRoot(String fileRoot) {
        this.fileRoot = fileRoot.endsWith(String.valueOf(File.separatorChar)) ? fileRoot : fileRoot + File.separatorChar;
    }

    public String getFileRoot() {
        return this.fileRoot;
    }

    private String matchFileToStoreUrl(String fileMd5, long fileSize) {
        String pathname = String.valueOf(fileMd5.charAt(0)) + File.separatorChar + fileMd5.charAt(1) + File.separatorChar + fileMd5.charAt(2);
        FileSystemOpt.createDirect((String)(this.getFileRoot() + pathname));
        return pathname + File.separatorChar + fileMd5 + "_" + fileSize + ".dat";
    }

    private String matchFileToStoreUrl(String fileMd5, long fileSize, String extName) {
        String pathname = String.valueOf(fileMd5.charAt(0)) + File.separatorChar + fileMd5.charAt(1) + File.separatorChar + fileMd5.charAt(2);
        FileSystemOpt.createDirect((String)(this.getFileRoot() + pathname));
        return pathname + File.separatorChar + fileMd5 + "_" + fileSize + "." + extName;
    }

    @Override
    public String saveFile(InputStream is, String fileMd5, long fileSize) throws IOException {
        String fileStroeUrl = this.matchFileToStoreUrl(fileMd5, fileSize);
        String filePath = this.getFileRoot() + fileStroeUrl;
        FileSystemOpt.createDirect((String)new File(filePath).getParent());
        FileIOOpt.writeInputStreamToFile((InputStream)is, (String)filePath);
        return fileStroeUrl;
    }

    public String saveFileByMd5(String sourFilePath, String fileMd5, long fileSize) throws IOException {
        String filePath = this.matchFileToStoreUrl(fileMd5, fileSize);
        FileSystemOpt.createDirect((String)new File(this.getFileRoot() + filePath).getParent());
        FileSystemOpt.fileCopy((String)sourFilePath, (String)(this.getFileRoot() + filePath));
        return filePath;
    }

    @Override
    public String saveFile(String sourFilePath, String fileMd5, long fileSize) throws IOException {
        return this.saveFileByMd5(sourFilePath, fileMd5, fileSize);
    }

    @Override
    public String saveFile(String sourFilePath, String fileMd5, long fileSize, String extName) throws IOException {
        String filePath = this.matchFileToStoreUrl(fileMd5, fileSize, extName);
        FileSystemOpt.createDirect((String)new File(this.getFileRoot() + filePath).getParent());
        FileSystemOpt.fileCopy((String)sourFilePath, (String)(this.getFileRoot() + filePath));
        return filePath;
    }

    @Override
    public String saveFile(String sourFilePath) throws IOException {
        File file = new File(sourFilePath);
        String fileMd5 = FileMD5Maker.makeFileMD5((File)file);
        long fileSize = file.length();
        return this.saveFileByMd5(sourFilePath, fileMd5, fileSize);
    }

    @Override
    public boolean checkFile(String fileMd5, long fileSize) {
        String filePath = this.getFileRoot() + this.matchFileToStoreUrl(fileMd5, fileSize);
        return FileSystemOpt.existFile((String)filePath);
    }

    @Override
    public String getFileStoreUrl(String fileMd5, long fileSize) {
        return this.matchFileToStoreUrl(fileMd5, fileSize);
    }

    @Override
    public String getFileStoreUrl(String fileMd5, long fileSize, String extName) {
        return this.matchFileToStoreUrl(fileMd5, fileSize, extName);
    }

    @Override
    public long getFileSize(String fileUrl) throws IOException {
        File f = new File(this.getFileRoot() + fileUrl);
        return f.length();
    }

    @Override
    public InputStream loadFileStream(String fileUrl) throws IOException {
        return new FileInputStream(new File(this.getFileRoot() + fileUrl));
    }

    @Override
    public InputStream loadFileStream(String fileMd5, long fileSize) throws IOException {
        return new FileInputStream(new File(this.getFileRoot() + this.matchFileToStoreUrl(fileMd5, fileSize)));
    }

    @Override
    public InputStream loadFileStream(String fileMd5, long fileSize, String extName) throws IOException {
        return new FileInputStream(new File(this.getFileRoot() + this.matchFileToStoreUrl(fileMd5, fileSize, extName)));
    }

    @Override
    public File getFile(String fileUrl) throws IOException {
        return new File(this.getFileRoot() + fileUrl);
    }

    @Override
    public boolean deleteFile(String fileUrl) throws IOException {
        return FileSystemOpt.deleteFile((String)(this.getFileRoot() + fileUrl));
    }

    @Override
    public boolean deleteFile(String fileMd5, long fileSize) throws IOException {
        return this.deleteFile(this.getFileStoreUrl(fileMd5, fileSize));
    }

    @Override
    public String getFileAccessUrl(String fileStoreUrl) {
        return fileStoreUrl;
    }

    @Override
    public String getFileAccessUrl(String fileMd5, long fileSize) {
        return this.getFileAccessUrl(this.getFileStoreUrl(fileMd5, fileSize));
    }
}

