/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.utils;

import com.alibaba.fastjson.JSONObject;
import com.centit.fileserver.utils.FileRangeInfo;
import com.centit.framework.common.ObjectException;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileMD5Maker;
import com.centit.support.file.FileSystemOpt;
import com.centit.support.file.FileType;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadDownloadUtils {
    private static final Logger logger = LoggerFactory.getLogger(UploadDownloadUtils.class);

    public static String encodeDownloadFilename(String paramName) {
        try {
            return new String(StringEscapeUtils.unescapeHtml4((String)paramName).getBytes("GBK"), "ISO8859-1");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u8f6c\u6362\u6587\u4ef6\u540d " + paramName + " \u62a5\u9519\uff1a" + e.getMessage(), (Throwable)e);
            return paramName;
        }
    }

    public static void downFileRange(HttpServletRequest request, HttpServletResponse response, InputStream inputStream, long fSize, String fileName) throws IOException {
        response.setContentType(FileType.getFileMimeType((String)fileName));
        response.setHeader("Accept-Ranges", "bytes");
        String s = request.getParameter("downloadType");
        response.setHeader("Content-Disposition", ("inline".equalsIgnoreCase(s) ? "inline" : "attachment") + "; filename=" + UploadDownloadUtils.encodeDownloadFilename(fileName));
        long pos = 0L;
        FileRangeInfo fr = FileRangeInfo.parseRange(request.getHeader("Range"));
        if (fr == null) {
            fr = new FileRangeInfo(0L, fSize - 1L, fSize);
        } else {
            if (fr.getRangeEnd() <= 0L) {
                fr.setRangeEnd(fSize - 1L);
            }
            fr.setFileSize(fSize);
            pos = fr.getRangeStart();
            if (fr.getPartSize() < fr.getFileSize()) {
                response.setStatus(206);
            }
        }
        response.setHeader("Content-Length", String.valueOf(fr.getPartSize()));
        response.setHeader("Content-Range", fr.getResponseRange());
        try (ServletOutputStream out = response.getOutputStream();
             BufferedOutputStream bufferOut = new BufferedOutputStream((OutputStream)out);){
            int writeLen;
            if (pos > 0L) {
                inputStream.skip(pos);
            }
            byte[] buffer = new byte[65536];
            int length = 0;
            for (int needSize = new Long(fr.getPartSize()).intValue(); needSize > 0 && (length = inputStream.read(buffer, 0, buffer.length)) != -1; needSize -= writeLen) {
                writeLen = needSize > length ? length : needSize;
                bufferOut.write(buffer, 0, writeLen);
                bufferOut.flush();
            }
        }
        catch (SocketException e) {
            logger.info("\u5ba2\u6237\u7aef\u65ad\u5f00\u94fe\u63a5\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    private static long checkTempFileSize(String filePath) {
        File f = new File(filePath);
        if (!f.exists()) {
            return 0L;
        }
        return f.length();
    }

    public static long uploadRange(String tempFilePath, InputStream fileInputStream, String token, long size, HttpServletRequest request) throws IOException, ObjectException {
        long tempFileSize = UploadDownloadUtils.checkTempFileSize(tempFilePath);
        FileRangeInfo range = FileRangeInfo.parseRange(request);
        if (tempFileSize < size) {
            if (tempFileSize != range.getRangeStart()) {
                throw new ObjectException(420, "Code: 420 RANGE\u683c\u5f0f\u9519\u8bef\u6216\u8005\u8d8a\u754c\u3002");
            }
            try (FileOutputStream out = new FileOutputStream(new File(tempFilePath), true);){
                int length = FileIOOpt.writeInputStreamToOutputStream((InputStream)fileInputStream, (OutputStream)out);
                if ((long)length != range.getPartSize()) {
                    throw new ObjectException(420, "Code: 420 RANGE\u683c\u5f0f\u9519\u8bef\u6216\u8005\u8d8a\u754c\u3002");
                }
            }
            tempFileSize = range.getRangeStart() + range.getPartSize();
        }
        if (tempFileSize == size) {
            String fileMd5 = FileMD5Maker.makeFileMD5((File)new File(tempFilePath));
            if (StringUtils.equals((CharSequence)fileMd5, (CharSequence)token)) {
                return 0L;
            }
            FileSystemOpt.deleteFile((String)tempFilePath);
            throw new ObjectException(425, "Code: 425 \u6587\u4ef6MD5\u8ba1\u7b97\u9519\u8bef\u3002");
        }
        return tempFileSize;
    }

    public static JSONObject makeRangeUploadJson(long rangeFileSize) {
        JSONObject json = new JSONObject();
        json.put("start", (Object)rangeFileSize);
        json.put("code", (Object)0);
        json.put("message", (Object)"\u4e0a\u4f20\u6587\u4ef6\u7247\u6bb5\u6210\u529f");
        json.put("data", (Object)rangeFileSize);
        return json;
    }
}

