package com.dingtalk.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.dingtalk.api.BaseDingTalkRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.dingtalk.api.response.CorpHealthStepinfoGetuserstatusResponse;

/**
 * TOP DingTalk-API: dingtalk.corp.health.stepinfo.getuserstatus request
 * 
 * @author top auto create
 * @since 1.0, 2018.02.27
 */
public class CorpHealthStepinfoGetuserstatusRequest extends BaseDingTalkRequest<CorpHealthStepinfoGetuserstatusResponse> {
	
	

	/** 
	* 用户id
	 */
	private String userid;

	public void setUserid(String userid) {
		this.userid = userid;
	}

	public String getUserid() {
		return this.userid;
	}

	public String getApiMethodName() {
		return "dingtalk.corp.health.stepinfo.getuserstatus";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("userid", this.userid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CorpHealthStepinfoGetuserstatusResponse> getResponseClass() {
		return CorpHealthStepinfoGetuserstatusResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(userid, "userid");
	}
	

}