/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.client;

import hector.me.prettyprint.cassandra.connection.ConcurrentHClientPool;
import hector.me.prettyprint.cassandra.connection.HClientPool;
import hector.me.prettyprint.cassandra.connection.LoadBalancingPolicy;
import hector.me.prettyprint.cassandra.connection.factory.HClientFactory;
import hector.me.prettyprint.cassandra.service.CassandraHost;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.extend.midlayer.common.FFSCalculatePartitionIdUtils;
import org.apache.cassandra.extend.midlayer.common.KeyEntity;
import org.apache.cassandra.extend.midlayer.common.PartitionTable;

public class FFSLoadBalancingPolicy
implements LoadBalancingPolicy {
    private static final long serialVersionUID = 775724707278900044L;
    private final PartitionTable partitionTable;
    private static ConcurrentHashMap<String, LoadBalanceRequestBean> threadSafedOperateKey = new ConcurrentHashMap();
    private static Comparator<Object> comparatorByAddress = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1.hashCode() < o2.hashCode()) {
                return 1;
            }
            return -1;
        }
    };

    FFSLoadBalancingPolicy(PartitionTable partitionTable) {
        this.partitionTable = partitionTable;
    }

    public HClientPool getPool(Collection<HClientPool> pools, Set<CassandraHost> excludeHosts) {
        if (this.partitionTable == null || this.partitionTable.isEmpty()) {
            return pools.iterator().next();
        }
        long threadId = Thread.currentThread().getId();
        LoadBalanceRequestBean loadBalanceRequestBean = threadSafedOperateKey.get(String.valueOf(threadId));
        String partitionId = "1";
        if (loadBalanceRequestBean.getKey() != null) {
            partitionId = FFSCalculatePartitionIdUtils.calculatePartitionId(loadBalanceRequestBean.getKey());
        }
        PartitionTable.Node node = null;
        node = OperationType.READ.equals((Object)loadBalanceRequestBean.getOperationType()) ? FFSLoadBalancingPolicy.getLoadBalanceStrategySelectedEndpoints(partitionId, this.partitionTable.getValidNode(loadBalanceRequestBean.getDc(), partitionId)) : this.tryGetWritableNode(loadBalanceRequestBean.getDc(), partitionId);
        for (HClientPool pool : pools) {
            if (!pool.getCassandraHost().getHost().equals(node.getHostAddress())) continue;
            return pool;
        }
        node.setNodeStatus(PartitionTable.Status.invalid);
        throw new HectorException("201::" + String.format("node:%s is invalid current,please try again!", node.getAddress()));
    }

    private PartitionTable.Node tryGetWritableNode(String dc, String partitionId) {
        PartitionTable.Node result = this.partitionTable.getWritableNode(dc, partitionId);
        result.setNodeStatus(PartitionTable.Status.writable);
        return result;
    }

    public static int getLoadBalanceSelectedEndpointsIndex(String partitionId, int selectedSize) {
        BigInteger md5Key = new BigInteger(partitionId);
        return md5Key.mod(new BigInteger(selectedSize + "")).intValue();
    }

    public static PartitionTable.Node getLoadBalanceStrategySelectedEndpoints(String partitionId, List<PartitionTable.Node> addresses) {
        if (addresses == null || addresses.size() == 0) {
            throw new HectorException("201::" + String.format("ALL node is valid for this group,please try again later!", new Object[0]));
        }
        Collections.sort(addresses, comparatorByAddress);
        ArrayList<PartitionTable.Node> nodeList = new ArrayList<PartitionTable.Node>();
        for (PartitionTable.Node node : addresses) {
            int i = 0;
            while ((long)i < node.getReadWeight()) {
                nodeList.add(node);
                ++i;
            }
        }
        int index = FFSLoadBalancingPolicy.getLoadBalanceSelectedEndpointsIndex(partitionId, nodeList.size());
        return (PartitionTable.Node)nodeList.get(index);
    }

    public HClientPool createConnection(HClientFactory clientFactory, CassandraHost host) {
        return new ConcurrentHClientPool(clientFactory, host);
    }

    void addThreadSafedOperateKey(LoadBalanceRequestBean loadBalanceRequestBean) {
        threadSafedOperateKey.put(String.valueOf(Thread.currentThread().getId()), loadBalanceRequestBean);
    }

    LoadBalanceRequestBean removeThreadSafedOperateKey() {
        return threadSafedOperateKey.remove(String.valueOf(Thread.currentThread().getId()));
    }

    protected static class LoadBalanceRequestBean {
        private KeyEntity key;
        private OperationType operationType;
        private String dc;

        protected LoadBalanceRequestBean(KeyEntity key, OperationType operationType, String dc) {
            this.key = key;
            this.operationType = operationType;
            this.dc = dc;
        }

        public String getDc() {
            return this.dc;
        }

        public void setDc(String dc) {
            this.dc = dc;
        }

        public KeyEntity getKey() {
            return this.key;
        }

        public void setKey(KeyEntity key) {
            this.key = key;
        }

        public OperationType getOperationType() {
            return this.operationType;
        }

        public void setOperationType(OperationType operationType) {
            this.operationType = operationType;
        }
    }

    protected static enum OperationType {
        WRITE,
        READ;

    }
}

