/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.client;

import hector.me.prettyprint.cassandra.model.BasicColumnDefinition;
import hector.me.prettyprint.cassandra.service.CassandraHostConfigurator;
import hector.me.prettyprint.cassandra.service.ThriftCluster;
import hector.me.prettyprint.hector.api.Cluster;
import hector.me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import hector.me.prettyprint.hector.api.ddl.ColumnType;
import hector.me.prettyprint.hector.api.ddl.ComparatorType;
import hector.me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import hector.me.prettyprint.hector.api.factory.HFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.extend.client.FFSClient;
import org.apache.cassandra.extend.client.FFSException;
import org.apache.cassandra.extend.midlayer.utils.ByteBufferUtil;
import org.apache.cassandra.thrift.commons.lang.StringUtils;

public class FFSManagerClient {
    private static String defaultClusterName = "defaultClusterName";
    private FFSClient ffsClient;
    private static final Map<String, Cluster> clusters = new ConcurrentHashMap<String, Cluster>();

    public void setAppNameConnectingFFS(String appNameConnectingFFSP) {
        FFSClient.setAppNameConnectingFFS(appNameConnectingFFSP);
    }

    public static FFSManagerClient createLocalClient(String hosts, String keyspaceName, int maxActive, String username, String password) {
        return new FFSManagerClient(hosts, keyspaceName, maxActive, username, password);
    }

    public static FFSManagerClient createRemoteClient(String hosts, String keyspaceName, int maxActive, int retrySubmitDelayInSeconds, String username, String password) {
        return new FFSManagerClient(hosts, keyspaceName, maxActive, retrySubmitDelayInSeconds, username, password);
    }

    private FFSManagerClient(String hosts, String keyspaceName, int maxActive, String username, String password) {
        this.ffsClient = FFSClient.getInstance(hosts, keyspaceName, maxActive, FFSClient.BlockSize.BlockSize_1M, username, password);
    }

    private FFSManagerClient(String hosts, String keyspaceName, int maxActive, int retrySubmitDelayInSeconds, String username, String password) {
        this.ffsClient = FFSClient.getInstanceForRemoteDC(hosts, keyspaceName, maxActive, FFSClient.BlockSize.BlockSize_1M, retrySubmitDelayInSeconds, username, password);
    }

    public FFSClient getFfsClient() {
        return this.ffsClient;
    }

    public void putBlob(String tableName, String key, byte[] value, Map<String, String> meta, long clock) throws FFSException {
        this.ffsClient.putBlob(tableName, key, value, meta, clock);
    }

    public long putBlob(String tableName, String key, InputStream value, Map<String, String> meta, long clock) throws IOException, FFSException {
        return this.ffsClient.putBlob(tableName, key, value, meta, clock);
    }

    public void delete(String cfName, String key, long clock) throws FFSException {
        this.ffsClient.delete(cfName, key, clock);
    }

    void flashback(String tableName, String bussinessKey, long beforeWhichTime) throws FFSException {
        this.ffsClient.flashback(tableName, bussinessKey, beforeWhichTime);
    }

    public static boolean isOkOfConnectedHost(String host) {
        FFSManagerClient client = FFSManagerClient.createLocalClient(host, "TEST_KEYSPACE", 1, "", "");
        try {
            int dc = client.ffsClient.getDCNameConnected();
            return dc > 0;
        }
        catch (FFSException e) {
            return false;
        }
    }

    public static int getDCNameConnected(String host) {
        FFSManagerClient client = FFSManagerClient.createLocalClient(host, "test", 1, "", "");
        try {
            int dc;
            int n = dc = client.ffsClient.getDCNameConnected();
            return n;
        }
        catch (FFSException e) {
            throw new RuntimeException("\u83b7\u53d6dc\u4fe1\u606f\u5f02\u5e38");
        }
        finally {
            FFSManagerClient fFSManagerClient = client;
            fFSManagerClient.ffsClient.shutdown();
        }
    }

    public static Map<String, ArrayList<String>> getSchema(String hosts, String username, String password) throws FFSException {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        try {
            Cluster clust = FFSManagerClient.getCluster(hosts, username, password);
            List keyspaces = clust.describeKeyspaces();
            for (KeyspaceDefinition keyspacedefinition : keyspaces) {
                ArrayList<String> cfs = new ArrayList<String>();
                for (ColumnFamilyDefinition cf : keyspacedefinition.getCfDefs()) {
                    cfs.add(cf.getName());
                }
                result.put(keyspacedefinition.getName(), cfs);
            }
        }
        catch (Exception e) {
            throw new FFSException(e);
        }
        return result;
    }

    private static String[] getCfReplicateDcFromCfnameComment(String comment) {
        String splictMatcher = ".+;replicate_dcs=(.+)";
        Pattern pattern = Pattern.compile(splictMatcher);
        Matcher matcher = pattern.matcher(comment);
        if (matcher.find()) {
            return matcher.group(1).split(",");
        }
        return new String[0];
    }

    public static Map<String, ArrayList<ClumnFamily>> getSchemaByDC(String hosts, String username, String password) throws FFSException {
        HashMap<String, ArrayList<ClumnFamily>> result = new HashMap<String, ArrayList<ClumnFamily>>();
        try {
            Cluster clust = FFSManagerClient.getCluster(hosts, username, password);
            List keyspaces = clust.describeKeyspaces();
            for (KeyspaceDefinition keyspacedefinition : keyspaces) {
                ArrayList<ClumnFamily> cfs = new ArrayList<ClumnFamily>();
                for (ColumnFamilyDefinition cf : keyspacedefinition.getCfDefs()) {
                    String[] dcs = FFSManagerClient.getCfReplicateDcFromCfnameComment(cf.getComment());
                    cfs.add(new ClumnFamily(cf.getName(), dcs));
                }
                result.put(keyspacedefinition.getName(), cfs);
            }
        }
        catch (Exception e) {
            throw new FFSException(e);
        }
        return result;
    }

    public static void repairReplicationOperationLog(String hosts, String database, String table, String key, long time, String username, String password) throws Exception {
        FFSClient client = FFSManagerClient.createLocalClient(hosts, database, 1, username, password).getFfsClient();
        client.repairReplicationOperationLog(table, key, time);
    }

    public static Map<String, String> getLoginInfo(String hosts, String username, String password) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            Cluster clust = FFSManagerClient.getCluster(hosts, username, password);
            List keyspaces = clust.describeKeyspaces();
            for (KeyspaceDefinition keyspacedefinition : keyspaces) {
                for (ColumnFamilyDefinition cf : keyspacedefinition.getCfDefs()) {
                    if (!"SYSTEM_TABLE_NAME_USED_BY_CLIENT".equals(cf.getName())) continue;
                    result.put(keyspacedefinition.getName(), cf.getComment());
                }
            }
        }
        catch (Exception e) {
            throw new FFSException(e);
        }
        return result;
    }

    public static void checkLogonUser(String username, String password) throws Exception {
        if (!"allow_all".equals(username)) {
            throw new FFSException("have no previlege for this operation!");
        }
    }

    private static Cluster getCluster(String hosts, String username, String password) throws Exception {
        FFSManagerClient.checkLogonUser(username, password);
        String key = hosts + username + password;
        if (!clusters.containsKey(key)) {
            CassandraHostConfigurator config = new CassandraHostConfigurator(hosts);
            config.setMaxActive(1);
            HashMap<String, String> credentials = new HashMap<String, String>();
            credentials.put("username", username);
            credentials.put("password", password);
            clusters.put(key, (Cluster)new ThriftCluster(defaultClusterName, config, credentials));
        }
        return clusters.get(key);
    }

    public static void updateTableComment(String hosts, String keyspace, String table, String comment, String username, String password) throws Exception {
        Cluster cluster = FFSManagerClient.getCluster(hosts, username, password);
        List cfds = cluster.describeKeyspace(keyspace).getCfDefs();
        for (ColumnFamilyDefinition cfd : cfds) {
            if (!StringUtils.equals((String)table, (String)cfd.getName())) continue;
            cfd.setComment(comment);
            cluster.updateColumnFamily(cfd);
            break;
        }
    }

    public static void updateSystemClientTableComment(String hosts, String keyspace, String comment, String username, String password) throws Exception {
        FFSManagerClient.updateTableComment(hosts, keyspace, "SYSTEM_TABLE_NAME_USED_BY_CLIENT", comment, username, password);
    }

    public static void addKeyspace(String hosts, String keyspace, String username, String password) throws Exception {
        Cluster cluster = FFSManagerClient.getCluster(hosts, username, password);
        final ColumnFamilyDefinition c = HFactory.createColumnFamilyDefinition((String)keyspace.trim(), (String)"SYSTEM_TABLE_NAME_USED_BY_CLIENT");
        KeyspaceDefinition ksdef = HFactory.createKeyspaceDefinition((String)keyspace.trim(), (String)"org.apache.cassandra.locator.NetworkTopologyStrategy", (int)1, (List)new ArrayList<ColumnFamilyDefinition>(){
            {
                this.add(c);
            }
        });
        cluster.addKeyspace(ksdef);
    }

    public static void addTable(String hosts, String keyspace, String table, String dcs, String username, String password) throws Exception {
        Cluster cluster = FFSManagerClient.getCluster(hosts, username, password);
        ArrayList<BasicColumnDefinition> columnMetadata = new ArrayList<BasicColumnDefinition>();
        BasicColumnDefinition cd = new BasicColumnDefinition();
        cd.setName(ByteBufferUtil.bytes("meta"));
        cd.setValidationClass("BytesType");
        columnMetadata.add(cd);
        cd = new BasicColumnDefinition();
        cd.setName(ByteBufferUtil.bytes("blob"));
        cd.setValidationClass("BytesType");
        columnMetadata.add(cd);
        ColumnFamilyDefinition c = HFactory.createColumnFamilyDefinition((String)keyspace.trim(), (String)table.trim(), (ComparatorType)ComparatorType.UTF8TYPE, columnMetadata);
        c.setColumnType(ColumnType.SUPER);
        c.setSubComparatorType(ComparatorType.UTF8TYPE);
        c.setReadRepairChance(0.0);
        c.setRowCacheKeysToSave(Integer.MAX_VALUE);
        if (StringUtils.isNotEmpty((String)dcs)) {
            c.setComment("serializer=org.apache.cassandra.extend.serialize.BlobRecordSerializer;replicate_dcs=" + dcs);
        } else {
            c.setComment("serializer=org.apache.cassandra.extend.serialize.BlobRecordSerializer;");
        }
        cluster.addColumnFamily(c);
    }

    public static Map<String, List<String>> describeSchemaConsistency(String hosts, String username, String password) throws Exception {
        Cluster cluster = FFSManagerClient.getCluster(hosts, username, password);
        return cluster.describeSchemaVersions();
    }

    public static void updateTable(String hosts, String keyspace, String table, String dcs, String username, String password) throws Exception {
        Cluster cluster = FFSManagerClient.getCluster(hosts, username, password);
        List cfs = cluster.describeKeyspace(keyspace).getCfDefs();
        for (ColumnFamilyDefinition cf : cfs) {
            if (!cf.getName().equals(table)) continue;
            if (StringUtils.isNotEmpty((String)dcs)) {
                cf.setComment("serializer=org.apache.cassandra.extend.serialize.BlobRecordSerializer;replicate_dcs=" + dcs);
            } else {
                cf.setComment("serializer=org.apache.cassandra.extend.serialize.BlobRecordSerializer;");
            }
            cluster.updateColumnFamily(cf);
        }
    }

    public static class ClumnFamily {
        public String name;
        public String[] replicateDc;

        public ClumnFamily(String name) {
            this.name = name;
        }

        public ClumnFamily(String name, String[] replicateDc) {
            this.name = name;
            this.replicateDc = replicateDc;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String[] getReplicateDc() {
            return this.replicateDc;
        }

        public String getReplicateDcStr() {
            StringBuffer sb = new StringBuffer();
            for (String rdc : this.replicateDc) {
                sb.append(rdc);
                sb.append(",");
            }
            if (sb.length() == 0) {
                return "";
            }
            return sb.substring(0, sb.length() - 1);
        }

        public void setReplicateDc(String[] replicateDc) {
            this.replicateDc = replicateDc;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof ClumnFamily) {
                return this.getName().equals(((ClumnFamily)obj).getName());
            }
            return false;
        }
    }
}

