/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.midlayer.common;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.cassandra.extend.midlayer.common.KeyEntity;
import org.apache.cassandra.extend.midlayer.utils.ByteBufferUtil;

public class FFSCalculatePartitionIdUtils {
    private static final ThreadLocal<MessageDigest> localMD5Digest = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            return FFSCalculatePartitionIdUtils.newMessageDigest("MD5");
        }

        @Override
        public MessageDigest get() {
            MessageDigest digest = (MessageDigest)super.get();
            digest.reset();
            return digest;
        }
    };
    protected static final BigInteger maxPartition = new BigInteger("1000");

    private static MessageDigest newMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("the requested digest algorithm (" + algorithm + ") is not available", nsae);
        }
    }

    public static String calculatePartitionId(KeyEntity key) {
        return FFSCalculatePartitionIdUtils.hashToBigInteger(ByteBufferUtil.bytes(key.getBussinessKey())).mod(maxPartition).toString();
    }

    public static String calculatePartitionId(String key) {
        return FFSCalculatePartitionIdUtils.hashToBigInteger(ByteBufferUtil.bytes(key)).mod(maxPartition).toString();
    }

    public static void main(String[] args) {
        System.out.println(FFSCalculatePartitionIdUtils.calculatePartitionId("1"));
        System.out.println(FFSCalculatePartitionIdUtils.calculatePartitionId("2"));
        System.out.println(FFSCalculatePartitionIdUtils.calculatePartitionId("3"));
        System.out.println(FFSCalculatePartitionIdUtils.calculatePartitionId("4"));
        System.out.println(FFSCalculatePartitionIdUtils.calculatePartitionId("5"));
        System.out.println(FFSCalculatePartitionIdUtils.calculatePartitionId("6"));
    }

    private static BigInteger hashToBigInteger(ByteBuffer data) {
        byte[] result = FFSCalculatePartitionIdUtils.hash(data);
        BigInteger hash = new BigInteger(result);
        return hash.abs();
    }

    private static byte[] hash(ByteBuffer ... data) {
        MessageDigest messageDigest = localMD5Digest.get();
        for (ByteBuffer block : data) {
            messageDigest.update(block.duplicate());
        }
        return messageDigest.digest();
    }
}

