/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.midlayer.common;

import com.focustech.umc.newprobe.gather.ProbeDataCollector;
import com.focustech.umc.newprobe.provider.AMonitorDataProvider;
import com.focustech.umc.newprobe.request.ProbePointRegister;
import com.focustech.umc.newprobe.request.thrift.ProbePointServer;
import com.focustech.umc.probe.request.AliveCheckI;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.dht.BigIntegerToken;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.extend.bdbengine.engine.BdbStorage;
import org.apache.cassandra.extend.bdbengine.engine.BlobStorage;
import org.apache.cassandra.extend.blob.ReadBlobCallback;
import org.apache.cassandra.extend.blob.ReadBlobVerbHandler;
import org.apache.cassandra.extend.blob.RemoteBlobService;
import org.apache.cassandra.extend.blob.WriteBlobVerbHandler;
import org.apache.cassandra.extend.client.FFSClient;
import org.apache.cassandra.extend.dcreplicate.GuiceModuleDCReplication;
import org.apache.cassandra.extend.dcreplicate.IAsynDCReplicationProcess;
import org.apache.cassandra.extend.endpointselecte.EndpointSelector;
import org.apache.cassandra.extend.endpointselecte.GuiceModuleEndPointsSelecte;
import org.apache.cassandra.extend.endpointselecte.ReadWeightManager;
import org.apache.cassandra.extend.midlayer.common.GroupsInfoTracker;
import org.apache.cassandra.extend.midlayer.common.GuiceModuleCommon;
import org.apache.cassandra.extend.midlayer.common.NodeInfo;
import org.apache.cassandra.extend.midlayer.common.SystemPropertiesManager;
import org.apache.cassandra.extend.midlayer.dbengine.IBlobStorage;
import org.apache.cassandra.extend.midlayer.dbengine.IBlockStorage;
import org.apache.cassandra.extend.midlayer.dbengine.IMasterRoleChangeListenerActionFromSystemLayer;
import org.apache.cassandra.extend.midlayer.dbengine.IRemoteBlobService;
import org.apache.cassandra.extend.midlayer.dbengine.IStorage;
import org.apache.cassandra.extend.midlayer.dbengine.IZookeeperClientWrapper;
import org.apache.cassandra.extend.midlayer.dbengine.RemoteBlobReadService;
import org.apache.cassandra.extend.midlayer.utils.ByteBufferUtil;
import org.apache.cassandra.extend.midlayer.utils.Utils;
import org.apache.cassandra.extend.monitor.environment.BdbEnvironment;
import org.apache.cassandra.extend.partition.GuiceModulePartition;
import org.apache.cassandra.extend.partition.IPartitionDistributionCache;
import org.apache.cassandra.extend.partition.IPartitionDistributionUpdater;
import org.apache.cassandra.extend.partition.PartitionDistribution;
import org.apache.cassandra.extend.partition.PartitionDistributionUpdater;
import org.apache.cassandra.extend.probe.AliveCheckByThrift;
import org.apache.cassandra.extend.probe.ProbeRequestHandler;
import org.apache.cassandra.extend.probe.newprobe.CheckFFSDataFileOperationLogProbe;
import org.apache.cassandra.extend.probe.newprobe.CheckSlaveHintProbe;
import org.apache.cassandra.extend.probe.newprobe.CheckThriftServerProbe;
import org.apache.cassandra.extend.probe.newprobe.CheckUnusableBlobReadNodesProbe;
import org.apache.cassandra.extend.probe.newprobe.ClientSessionsProbe;
import org.apache.cassandra.extend.probe.newprobe.CollectionIOProvider;
import org.apache.cassandra.extend.probe.newprobe.CollectionWarnProvider;
import org.apache.cassandra.extend.probe.newprobe.CurrentVLSNCountProbe;
import org.apache.cassandra.extend.probe.newprobe.DcReplicationProcessProbe;
import org.apache.cassandra.extend.probe.newprobe.MasterLockConsistencyProbe;
import org.apache.cassandra.extend.probe.newprobe.MemoryUsageProbe;
import org.apache.cassandra.extend.probe.newprobe.ProbeCommonModule;
import org.apache.cassandra.extend.probe.newprobe.RPCTimedoutEndpointsNumProbe;
import org.apache.cassandra.extend.probe.newprobe.ReplicaSyncLagProbe;
import org.apache.cassandra.extend.probe.newprobe.ReplicationMessageInfoCounterProbe;
import org.apache.cassandra.extend.probe.newprobe.ReplicationMessageInfoSizeProbe;
import org.apache.cassandra.extend.probe.newprobe.ThreadCountProbe;
import org.apache.cassandra.extend.probe.newprobe.WatcherProcessProbe;
import org.apache.cassandra.extend.rebalance.GuiceModuleRebalance;
import org.apache.cassandra.extend.rebalance.IRebalanceProcess;
import org.apache.cassandra.extend.service.BDBWriteResponseHandler;
import org.apache.cassandra.extend.service.DealReadRequestTypeManager;
import org.apache.cassandra.extend.service.GuiceModuleService;
import org.apache.cassandra.extend.service.MasterRoleChangeListenerActionFromSystemLayer;
import org.apache.cassandra.extend.service.ReadCallbackWithErrorMessange;
import org.apache.cassandra.extend.service.ZookeeperClientWrapper;
import org.apache.cassandra.extend.service.quartz.FFSQuartzFactory;
import org.apache.cassandra.extend.service.replay.RowReplayRequestVerbHandler;
import org.apache.cassandra.extend.service.replay.dispatcher.ReplicationDispatchManager;
import org.apache.cassandra.extend.service.replay.replicationChannel.http.HttpReplicationProcess;
import org.apache.cassandra.extend.service.replay.replicationChannel.http.HttpReplicationServer;
import org.apache.cassandra.extend.service.replay.replicationChannel.http.ReplicationChannelTypeManager;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.IMessageCallback;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.IReadCommand;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.RowDigestResolver;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeContext {
    private static Logger logger_ = LoggerFactory.getLogger(NodeContext.class);
    private NodeInfo nodeInfo;
    private String dataDirectory;
    private TokenMetadata tokenMeta;
    private IStorage storage = null;
    private static SystemPropertiesManager systemPropertiesManager = null;
    private static IZookeeperClientWrapper iZookeeperClientWrapper = null;
    private static DealReadRequestTypeManager dealReadRequestTypeManager = null;
    private static ReplicationDispatchManager replicationDispatchManager = null;
    private static ReplicationChannelTypeManager replicationChannelTypeManager = null;
    private Injector injector = null;
    private static NodeContext instance = null;
    private static Boolean isBlobServer = null;
    private static final ReentrantLock unitTestLock = new ReentrantLock();
    private static final ReentrantLock unitTestLockOfNodeRole = new ReentrantLock();

    NodeContext(NodeInfo nodeInfo, String dataDirectory, TokenMetadata tokenMeta, Injector injector) {
        this.nodeInfo = nodeInfo;
        this.dataDirectory = dataDirectory;
        this.tokenMeta = tokenMeta;
        this.injector = injector;
    }

    public static boolean isBlobServer() {
        if (isBlobServer == null) {
            isBlobServer = Boolean.getBoolean("isBlobServer");
        }
        return isBlobServer;
    }

    public static IBlockStorage tryToTransToBlockStorage(IStorage storage, String invokMethod) {
        if (!(storage instanceof IBlockStorage)) {
            throw new RuntimeException(String.format("blob cluster can not do:%s!", invokMethod));
        }
        IBlockStorage blockStorage = (IBlockStorage)storage;
        return blockStorage;
    }

    private void init() {
        NodeContextInvokeID nodeContextInvokeID = new NodeContextInvokeID();
        this.storage.registeMasterRoleChangeListenerActionFromSystemLayer((IMasterRoleChangeListenerActionFromSystemLayer)new MasterRoleChangeListenerActionFromSystemLayer());
        IAsynDCReplicationProcess asynDCReplicationProcess = this.getInstanceFromInjector(IAsynDCReplicationProcess.class);
        IRebalanceProcess rebalanceProcess = this.getInstanceFromInjector(IRebalanceProcess.class);
        asynDCReplicationProcess.registe(this.storage);
        rebalanceProcess.registe(this.storage);
        if (StringUtils.equals((String)System.getProperty("reloadSchema"), (String)"yes")) {
            try {
                logger_.info("I will waiting 1 mins for reload schema!");
                Thread.sleep(300000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        RowMutation.registe((IStorage)this.storage);
        SliceByNamesReadCommand.registe((IStorage)this.storage);
        RowReplayRequestVerbHandler.registe((IStorage)this.storage);
        PartitionDistributionUpdater partitionDistributionUpdater = new PartitionDistributionUpdater(nodeContextInvokeID);
        rebalanceProcess.registe((IPartitionDistributionUpdater)partitionDistributionUpdater);
        BDBWriteResponseHandler.registe((IPartitionDistributionUpdater)partitionDistributionUpdater);
        BdbEnvironment.buildInstance((IStorage)this.storage, (IPartitionDistributionUpdater)partitionDistributionUpdater);
        if (!NodeContext.isBlobServer()) {
            asynDCReplicationProcess.start(nodeContextInvokeID);
            HttpReplicationServer server = new HttpReplicationServer();
            server.startReplicationServer();
            HttpReplicationProcess.getInstance((RemoteBlobReadService)((BdbStorage)this.storage).getRemoteBlobReadService()).start();
        }
        rebalanceProcess.start(nodeContextInvokeID);
        ProbeCommonModule.register((IStorage)this.storage);
        FFSQuartzFactory.startFFSQuartz();
        FFSClient.setAppNameConnectingFFS("ffs_server");
        logger_.info("MULTI_INSTANCE_ON_ONE_MACHINE:" + System.getProperty("MULTI_INSTANCE_ON_ONE_MACHINE"));
        logger_.info("maxVlsnNumRatio:" + System.getProperty("maxVlsnNumRatio"));
    }

    private static void startUMCScan() {
        int probePort = NodeContext.getSystemPropertiesManager().getProbeport();
        String ip = NodeContext.getSystemPropertiesManager().getIp();
        logger_.info("ip is:" + ip + " ,probePort is :" + probePort);
        try {
            NodeContext.checkPortBindWithHandler(ip, probePort);
        }
        catch (Exception e) {
            logger_.error("Port:" + probePort + " has already bind! Exits");
            return;
        }
        ProbePointServer porbeServerThread = new ProbePointServer(probePort, (ProbeDataCollector)new ProbeRequestHandler((AliveCheckI)new AliveCheckByThrift()), new ProbePointRegister(){

            public List<Class<? extends AMonitorDataProvider>> registerMonitorDataProvider() {
                ArrayList<Class<? extends AMonitorDataProvider>> realTimes = new ArrayList<Class<? extends AMonitorDataProvider>>();
                realTimes.add(CollectionIOProvider.class);
                realTimes.add(CollectionWarnProvider.class);
                realTimes.add(MasterLockConsistencyProbe.class);
                realTimes.add(WatcherProcessProbe.class);
                if (!NodeContext.isBlobServer()) {
                    realTimes.add(DcReplicationProcessProbe.class);
                    realTimes.add(CheckUnusableBlobReadNodesProbe.class);
                    realTimes.add(ClientSessionsProbe.class);
                }
                realTimes.add(RPCTimedoutEndpointsNumProbe.class);
                realTimes.add(CheckSlaveHintProbe.class);
                realTimes.add(ThreadCountProbe.class);
                realTimes.add(CheckFFSDataFileOperationLogProbe.class);
                realTimes.add(MemoryUsageProbe.class);
                realTimes.add(CurrentVLSNCountProbe.class);
                realTimes.add(ReplicationMessageInfoSizeProbe.class);
                realTimes.add(ReplicationMessageInfoCounterProbe.class);
                realTimes.add(ReplicaSyncLagProbe.class);
                realTimes.add(CheckThriftServerProbe.class);
                return realTimes;
            }
        });
        porbeServerThread.start();
    }

    private static void checkPortBindWithHandler(String ip, int ... ports) throws InterruptedException {
        int times = 0;
        for (int port : ports) {
            while (NodeContext.socketAddressIsBind(ip, port)) {
                Thread.sleep(10000L);
                if (++times <= 18) continue;
                throw new RuntimeException("Port has already bind!");
            }
        }
    }

    public static synchronized ReplicationChannelTypeManager getReplicationChannelTypeManager() {
        if (replicationChannelTypeManager == null) {
            replicationChannelTypeManager = new ReplicationChannelTypeManager();
        }
        return replicationChannelTypeManager;
    }

    public static synchronized ReplicationDispatchManager getReplicationDispatchManager() {
        if (replicationDispatchManager == null) {
            replicationDispatchManager = new ReplicationDispatchManager();
        }
        return replicationDispatchManager;
    }

    public static synchronized DealReadRequestTypeManager getDealReadRequestTypeManager() {
        if (dealReadRequestTypeManager == null) {
            dealReadRequestTypeManager = new DealReadRequestTypeManager();
        }
        return dealReadRequestTypeManager;
    }

    public static synchronized SystemPropertiesManager getSystemPropertiesManager() {
        if (systemPropertiesManager == null) {
            systemPropertiesManager = new SystemPropertiesManager();
        }
        return systemPropertiesManager;
    }

    public static synchronized IZookeeperClientWrapper getIZookeeperClientWrapper() {
        if (iZookeeperClientWrapper == null) {
            iZookeeperClientWrapper = new ZookeeperClientWrapper(NodeContext.getSystemPropertiesManager());
        }
        return iZookeeperClientWrapper;
    }

    public static NodeContext getInstance(NodeInfo nodeInfo, String dataDirectory, TokenMetadata tokenMeta) {
        if (instance == null) {
            Injector injector;
            NodeContext.startUMCScan();
            NodeContextInvokeID nodeContextInvokeID = new NodeContextInvokeID();
            instance = new NodeContext(nodeInfo, dataDirectory, tokenMeta, null);
            NodeContext.instance.injector = injector = Guice.createInjector((Module[])new Module[]{new GuiceModuleDCReplication(), new GuiceModuleEndPointsSelecte(), new GuiceModuleCommon(), new GuiceModulePartition(), new GuiceModuleRebalance(), new GuiceModuleService()});
            SystemPropertiesManager systemPropertiesManager = (SystemPropertiesManager)injector.getInstance(SystemPropertiesManager.class);
            if (Utils.portIsBindOnLookbackAndAnyInteAddresses(systemPropertiesManager.getMonitorServerPort()) || Utils.portIsBindOnLookbackAndAnyInteAddresses(systemPropertiesManager.getServerDemonPort())) {
                logger_.error("monitorPort or processPort has been bind,I will exit!");
                System.exit(0);
            }
            if (!instance.checkLegalityOfMultiInstanceOnOneMachine()) {
                logger_.error("there is multi instance on this machine but you did not define MULTI_INSTANCE_ON_ONE_MACHINE as yes,I will exit!");
                System.exit(0);
            }
            if (NodeContext.isBlobServer()) {
                BlobStorage blobStorage = new BlobStorage(nodeContextInvokeID);
                ReadBlobVerbHandler.registe((IBlobStorage)blobStorage);
                WriteBlobVerbHandler.registe((IBlobStorage)blobStorage);
                NodeContext.instance.storage = blobStorage;
            } else {
                RemoteBlobService remoteBlobService = new RemoteBlobService();
                BdbStorage storage = new BdbStorage(nodeContextInvokeID, (IRemoteBlobService)remoteBlobService);
                NodeContext.instance.storage = storage;
            }
            instance.init();
        }
        return instance;
    }

    public static NodeContext getInstanceOnlyWithInjector(NodeInfo nodeInfo, Injector injector) {
        if (instance == null) {
            instance = new NodeContext(nodeInfo, null, null, injector);
        }
        return instance;
    }

    public static NodeContext getInstance() {
        for (int i = 0; instance == null && i < 600; ++i) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (instance == null) {
            throw new RuntimeException("you should call getInstance( params) first when start!");
        }
        return instance;
    }

    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public TokenMetadata getTokenMetadata() {
        return this.tokenMeta.cloneOnlyTokenMap();
    }

    public boolean isMaster() {
        return this.storage.isMaster();
    }

    public <T> T getInstanceFromInjector(Class<T> type) {
        return (T)this.injector.getInstance(type);
    }

    public Set<String> getAllDCs() {
        Map tokenToEndpointMap = this.getTokenMetadata().getTokenToEndpointMap();
        HashSet<String> dcs = new HashSet<String>();
        for (Token token : tokenToEndpointMap.keySet()) {
            int nodeTokenAsInt = ((BigInteger)token.token).intValue();
            NodeInfo nodeInfo = new NodeInfo(nodeTokenAsInt);
            dcs.add(nodeInfo.getDcName());
        }
        return dcs;
    }

    public String getLocalDC() {
        return this.nodeInfo.getDcName();
    }

    public Set<String> getTargetDCs() {
        Set<String> ret = this.getAllDCs();
        ret.remove(this.getLocalDC());
        return ret;
    }

    public void shutdown() {
        logger_.info("system exit::start shutdown system exit...");
        if (this.isMaster()) {
            this.notifyTheOtherNodesOfCurrentGroup();
        }
        this.storage.close();
        logger_.info("system exit::end shutdown before system exit.");
    }

    private void notifyTheOtherNodesOfCurrentGroup() {
        ArrayList endPointsInCurrentGroupCopy = new ArrayList();
        try {
            EndpointSelector endpointSelector = instance.getInstanceFromInjector(EndpointSelector.class);
            endPointsInCurrentGroupCopy.addAll(endpointSelector.getEndPointsInGroup(instance.getNodeInfo().getGroupName()));
            endPointsInCurrentGroupCopy.remove(FBUtilities.getBroadcastAddress());
        }
        catch (Throwable e) {
            logger_.error("slavehint::failed to notifyTheOtherNodeOfCurrentNode!", e);
        }
        if (endPointsInCurrentGroupCopy.size() > 0) {
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime <= 60000L) {
                try {
                    ArrayList<Object> handlers = new ArrayList<Object>();
                    for (InetAddress inetAddress : endPointsInCurrentGroupCopy) {
                        if (NodeContext.isBlobServer()) {
                            handlers.add(this.sendNotifyMessageForBlobCluster(inetAddress, startTime + ""));
                            continue;
                        }
                        handlers.add(this.sendNotifyMessage(inetAddress, startTime + ""));
                    }
                    for (IAsyncCallback iAsyncCallback : handlers) {
                        if (NodeContext.isBlobServer()) {
                            ((ReadBlobCallback)iAsyncCallback).get();
                            continue;
                        }
                        ((ReadCallbackWithErrorMessange)iAsyncCallback).get();
                    }
                    logger_.info("slavehint::sucessed to notifyTheOtherNodeOfCurrentNode");
                    break;
                }
                catch (Throwable e) {
                    logger_.error("slavehint::failed to notifyTheOtherNodeOfCurrentNode,I will try again!", e);
                    try {
                        Thread.sleep(2L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }

    private ReadCallbackWithErrorMessange<Row> sendNotifyMessage(final InetAddress theOtherNodeOfCurrentGroup, String notifyVersion) throws IOException {
        QueryPath path = new QueryPath("checkTable", null);
        ArrayList<ByteBuffer> column_names = new ArrayList<ByteBuffer>();
        column_names.add(ByteBufferUtil.bytes("timestamp"));
        SliceByNamesReadCommand command = new SliceByNamesReadCommand("test", ByteBufferUtil.bytes("ffs_notify_the_othre_node_of_current_group_closing_node" + notifyVersion + "~lia1234567899876543219a"), path, column_names);
        RowDigestResolver resolver = new RowDigestResolver(command.table, command.key);
        ReadCallbackWithErrorMessange handler = new ReadCallbackWithErrorMessange((IResponseResolver)resolver, (IReadCommand)command, (List)new ArrayList<InetAddress>(){
            {
                this.add(theOtherNodeOfCurrentGroup);
            }
        });
        Message message = command.getMessage(Gossiper.instance.getVersion(theOtherNodeOfCurrentGroup));
        String version = NodeContext.getInstance().getInstanceFromInjector(IPartitionDistributionCache.class).getLocalCurrentPartitionDistribution().getVersion() + "";
        message = message.withHeaderAdded("partition_distribution_version_on_source", version.getBytes());
        MessagingService.instance().sendRR(message, theOtherNodeOfCurrentGroup, (IMessageCallback)handler);
        return handler;
    }

    private ReadBlobCallback sendNotifyMessageForBlobCluster(InetAddress theOtherNodeOfCurrentGroup, String notifyVersion) {
        Message message = new Message(FBUtilities.getBroadcastAddress(), StorageService.Verb.MY_BLOB_READ_REQUEST_BETWEEN_BLOB_NODES, new byte[0], Gossiper.instance.getVersion(theOtherNodeOfCurrentGroup).intValue());
        message = message.withHeaderAdded("BLOB_REQUEST_MD5KEY", ("ffs_notify_the_othre_node_of_current_group_closing_node" + notifyVersion + "~lia1234567899876543219a").getBytes());
        String version = NodeContext.getInstance().getInstanceFromInjector(IPartitionDistributionCache.class).getLocalCurrentPartitionDistribution().getVersion() + "";
        message = message.withHeaderAdded("partition_distribution_version_on_source", version.getBytes());
        ReadBlobCallback readBlobCallback = new ReadBlobCallback(theOtherNodeOfCurrentGroup);
        MessagingService.instance().sendRR(message, theOtherNodeOfCurrentGroup, (IMessageCallback)readBlobCallback);
        return readBlobCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean socketAddressIsBind(String ip, int port) {
        Socket bindServer = new Socket();
        InetSocketAddress address = new InetSocketAddress(ip, port);
        try {
            bindServer.bind(address);
        }
        catch (IOException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                bindServer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private boolean checkLegalityOfMultiInstanceOnOneMachine() {
        List<String> allIPsOfCurrentMachine = this.getAllIPsOfCurrentMachine();
        List<String> allNodesOfCurrentDC = this.getAllNodesOfCurrentDC();
        if (allIPsOfCurrentMachine == null) {
            return false;
        }
        logger_.info("ips:" + allIPsOfCurrentMachine);
        HashSet<String> coverlaps = new HashSet<String>();
        for (String IPOfCurrentMachine : allIPsOfCurrentMachine) {
            if (!allNodesOfCurrentDC.contains(IPOfCurrentMachine)) continue;
            coverlaps.add(IPOfCurrentMachine);
        }
        logger_.info("coverlaps size:" + coverlaps.size());
        return coverlaps.size() <= 1 || "yes".equals(System.getProperty("MULTI_INSTANCE_ON_ONE_MACHINE"));
    }

    private List<String> getAllIPsOfCurrentMachine() {
        try {
            ArrayList<String> allHostIps = new ArrayList<String>();
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = netInterfaces.nextElement();
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    allHostIps.add(ip.getHostAddress());
                }
            }
            return allHostIps;
        }
        catch (Exception e) {
            logger_.error("failed to get getAllIPsOfCurrentMachine!");
            return null;
        }
    }

    private List<String> getAllNodesOfCurrentDC() {
        ArrayList<String> ret = new ArrayList<String>();
        Map tokenToEndpointMap = this.getTokenMetadata().getTokenToEndpointMap();
        for (Token token : tokenToEndpointMap.keySet()) {
            int tokenAsInt = ((BigInteger)((BigIntegerToken)token).token).intValue();
            NodeInfo node = new NodeInfo(tokenAsInt);
            if (!node.getDcName().equals(this.nodeInfo.getDcName())) continue;
            InetAddress endpoint = (InetAddress)tokenToEndpointMap.get(token);
            ret.add(endpoint.getHostAddress());
        }
        return ret;
    }

    public void removeNode(InetAddress nodeAddress) {
        TokenMetadata metadata = this.getTokenMetadata();
        Token token = metadata.getToken(nodeAddress);
        int tokenAsInt = ((BigInteger)((BigIntegerToken)token).token).intValue();
        NodeInfo node = new NodeInfo(tokenAsInt);
        if (node.getLoadWeight() != 0 && !Boolean.getBoolean("isForceRemoveNode")) {
            throw new RuntimeException("removed token's loadweight is not 000 ,so I won't remove node for: " + nodeAddress);
        }
        InetAddress removeIp = metadata.getEndpoint(token);
        String usedTokenString = ((BigInteger)((BigIntegerToken)token).token).toString();
        if (!nodeAddress.equals(removeIp)) {
            throw new RuntimeException(String.format("request remove ip is %s,token is %s but get ip from token is %s", nodeAddress, usedTokenString, removeIp));
        }
        if (this.getInstanceFromInjector(EndpointSelector.class).isStarted(nodeAddress)) {
            throw new RuntimeException("remove node must stoped!");
        }
        if (!Boolean.getBoolean("isObsoletedNodeRemover")) {
            throw new RuntimeException("I am not node remover,you must special it by -DisObsoletedNodeRemover!");
        }
        this.tryDelGroupInfoIfGroupWillDeleted(node.getDcName(), node.getGroupName());
        this.getStorageService().removeToken(usedTokenString);
        logger_.info(String.format("token:%s has been removed from big cluster!", usedTokenString));
    }

    private boolean isNeedDeleteGroupIfWhenNodeRemove(String dc, String group) {
        EndpointSelector endpointSelector = this.getInstanceFromInjector(EndpointSelector.class);
        if (endpointSelector.getAllNomalNodesOfGivenDC(dc).size() == 0) {
            return false;
        }
        List nodesInGroup = endpointSelector.getAllNodesOfGivenDCAndGroup(dc, group);
        return nodesInGroup.size() == 1;
    }

    protected void tryDelGroupInfoIfGroupWillDeleted(String dc, String group) {
        if (this.isNeedDeleteGroupIfWhenNodeRemove(dc, group)) {
            if (!StringUtils.equals((String)dc, (String)this.getLocalDC())) {
                throw new RuntimeException("remove group info must in same dc");
            }
            PartitionDistribution.PartitionsGroup partitionsGroup = this.getInstanceFromInjector(IPartitionDistributionCache.class).getLocalCurrentPartitionDistribution().getPartitionsGroup(group);
            if (partitionsGroup != null && partitionsGroup.getLoadWeight() != 0) {
                throw new RuntimeException("must rebalance date to other group first when delete node for group:" + group);
            }
            if (this.getInstanceFromInjector(IRebalanceProcess.class).rebalanceCommandExisting()) {
                throw new RuntimeException("must completed rebalance before remove node");
            }
            logger_.info(String.format("I will start delete node info for dc:%s and group:%s", dc, group));
            this.delGroupInfo(group);
            logger_.info(String.format("I end delete node info for dc:%s and group:%s", dc, group));
        }
    }

    protected void delGroupInfo(String group) {
        NodeContextInvokeID nodeContextInvokeID = new NodeContextInvokeID();
        if (!NodeContext.isBlobServer()) {
            this.getInstanceFromInjector(IAsynDCReplicationProcess.class).clearReplicationProcessInfoByGroupWhenRemoveGroup(group, nodeContextInvokeID);
        }
        ReadWeightManager.getInstance().clearReadWeightByGroupWhenRemoveGroup(group, nodeContextInvokeID);
        this.getInstanceFromInjector(GroupsInfoTracker.class).clearGroupInfoWhenRemoveGroup(group, nodeContextInvokeID);
    }

    protected StorageService getStorageService() {
        return StorageService.instance;
    }

    public static void setUpInUnitTest(NodeContext nodeContextMock) {
        if (!"YES".equals(System.getProperty("UNIT_TEST_FLAG"))) {
            throw new RuntimeException("this method should be called only in unit test!");
        }
        unitTestLock.lock();
        instance = nodeContextMock;
    }

    public static void tearDownInUnitTest() {
        if (!"YES".equals(System.getProperty("UNIT_TEST_FLAG"))) {
            throw new RuntimeException("this method should be called only in unit test!");
        }
        instance = null;
        unitTestLock.unlock();
    }

    public static void setUpNodeRoleInUnitTest(Boolean isBlobServerP) {
        if (!"YES".equals(System.getProperty("UNIT_TEST_FLAG"))) {
            throw new RuntimeException("this method should be called only in unit test!");
        }
        unitTestLockOfNodeRole.lock();
        isBlobServer = isBlobServerP;
    }

    public static void tearDownRoleInUnitTest() {
        if (!"YES".equals(System.getProperty("UNIT_TEST_FLAG"))) {
            throw new RuntimeException("this method should be called only in unit test!");
        }
        isBlobServer = null;
        unitTestLockOfNodeRole.unlock();
    }

    public static boolean needConnectTo(InetAddress to) {
        if (NodeContext.isBlobServer()) {
            return true;
        }
        HashMap<Token, InetAddress> allTokensLoaded = NodeContext.getAllTokensInSystemtable();
        Token firstTokenMapped = null;
        for (Map.Entry<Token, InetAddress> tokensLoadedEntry : allTokensLoaded.entrySet()) {
            if (!to.equals(tokensLoadedEntry.getValue())) continue;
            if (firstTokenMapped == null) {
                firstTokenMapped = tokensLoadedEntry.getKey();
                continue;
            }
            if (NodeContext.tokenEqualsByDC(firstTokenMapped, tokensLoadedEntry.getKey())) continue;
            return true;
        }
        try {
            Token destinationToken;
            TokenMetadata tokenMetadata = NodeContext.getInstance().getTokenMetadata();
            Token token = destinationToken = tokenMetadata.isMember(to) ? tokenMetadata.getToken(to) : null;
            if (destinationToken != null) {
                int destinationTokenAsInt = ((BigInteger)((BigIntegerToken)destinationToken).token).intValue();
                String destinationDC = new NodeInfo(destinationTokenAsInt).getDcName();
                String localDC = NodeContext.getInstance().getNodeInfo().getDcName();
                String localBroadcastAddress = DatabaseDescriptor.getBroadcastAddress().getHostAddress();
                HashSet<String> seedIpPerDCs = new HashSet<String>();
                for (InetAddress address : DatabaseDescriptor.getSeeds()) {
                    seedIpPerDCs.add(address.getHostAddress());
                }
                if (!(localDC.equals(destinationDC) || seedIpPerDCs.size() <= 0 || seedIpPerDCs.contains(to.getHostAddress()) && seedIpPerDCs.contains(localBroadcastAddress))) {
                    return false;
                }
            }
        }
        catch (Throwable e) {
            logger_.warn("there is bug in needConnectTo,check it!");
        }
        return true;
    }

    public void tryToSavePartitionDistributionToSystemAdditionalInfosNotepad() {
        try {
            if (NodeContext.getInstance().isMaster()) {
                PartitionDistribution partitionDistribution = NodeContext.getInstance().getInstanceFromInjector(IPartitionDistributionCache.class).getLocalCurrentPartitionDistribution();
                this.storage.getSystemAdditionalInfoNotepad().putLocalCurrentPartitions(partitionDistribution);
            }
        }
        catch (Throwable e) {
            logger_.error("save partitionDistribution to OuterAssistantInfoNotepad is error", e);
        }
    }

    public PartitionDistribution getPartitionDistributionFromSystemAdditionalInfosNotepad() {
        try {
            return this.storage.getSystemAdditionalInfoNotepad().getLocalCurrentPartitions();
        }
        catch (Throwable e) {
            logger_.error("get partitionDistribution From OuterAssistantInfoNotepad is error", e);
            throw new RuntimeException(e);
        }
    }

    public Map<BigInteger, String> getErrorTokens() {
        HashMap<BigInteger, String> errorTokens = new HashMap<BigInteger, String>();
        TokenMetadata tokenMetadata = this.getTokenMetadata();
        HashMap<Token, InetAddress> tokensInSystemtable = NodeContext.getAllTokensInSystemtable();
        for (Map.Entry<Token, InetAddress> entryInSystemtable : tokensInSystemtable.entrySet()) {
            if (NodeContext.tokenEqualsByDC(tokenMetadata.getToken(entryInSystemtable.getValue()), entryInSystemtable.getKey())) continue;
            errorTokens.put((BigInteger)((BigIntegerToken)entryInSystemtable.getKey()).token, entryInSystemtable.getValue().getHostAddress());
        }
        return errorTokens;
    }

    public void removeErrorTokenFromSystemTabel(Token tokenToBeRemoved) throws Exception {
        InetAddress nodeInetAddress = NodeContext.getAllTokensInSystemtable().get(tokenToBeRemoved);
        if (NodeContext.tokenEqualsByDC(tokenToBeRemoved, this.getTokenMetadata().getToken(nodeInetAddress))) {
            throw new Exception(tokenToBeRemoved + " is not an error token!");
        }
        SystemTable.removeToken((Token)tokenToBeRemoved);
        logger_.info(String.format("token:%s has been removed!", tokenToBeRemoved));
    }

    private static HashMap<Token, InetAddress> getAllTokensInSystemtable() {
        return SystemTable.loadTokens();
    }

    private static boolean tokenEqualsByDC(Token token1, Token token2) {
        String dc1 = new NodeInfo(((BigInteger)((BigIntegerToken)token1).token).intValue()).getDcName();
        String dc2 = new NodeInfo(((BigInteger)((BigIntegerToken)token2).token).intValue()).getDcName();
        return dc1.equals(dc2);
    }

    public static class NodeContextInvokeID {
        private NodeContextInvokeID() {
        }

        public String getInvoker() {
            return NodeContext.class.getSimpleName();
        }
    }
}

