/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.midlayer.common;

public class NodeInfo {
    public static final String NODE_FLAG_IN_GROUP_2 = "2";
    public static final String NODE_FLAG_IN_GROUP_1 = "1";
    public static final String NODE_FLAG_IN_GROUP_0 = "0";
    private String dcName;
    private int initToken;
    private String nodeFlagInGroup;
    private String groupName;
    private int loadWeight = 10;

    public NodeInfo(int initToken) {
        if (initToken / 10000000 < 1) {
            throw new RuntimeException(String.format("initToken:%d is illegal!", initToken));
        }
        this.initToken = initToken;
        this.dcName = initToken / 10000000 % 10 + "";
        this.groupName = initToken / 10000 % 1000 + "";
        this.nodeFlagInGroup = initToken / 1000 % 10 + "";
        this.loadWeight = initToken % 1000;
        if (!(NODE_FLAG_IN_GROUP_2.equals(this.nodeFlagInGroup) || NODE_FLAG_IN_GROUP_1.equals(this.nodeFlagInGroup) || NODE_FLAG_IN_GROUP_0.equals(this.nodeFlagInGroup))) {
            throw new RuntimeException(String.format("nodeFlagInGroup:%d is illegal!", this.nodeFlagInGroup));
        }
    }

    public int getInitToken() {
        return this.initToken;
    }

    public String getNodeFlagInGroup() {
        return this.nodeFlagInGroup;
    }

    public String getNodeName() {
        return this.groupName + "_" + this.getNodeFlagInGroup();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public int getLoadWeight() {
        return this.loadWeight;
    }

    public String getDcName() {
        return this.dcName;
    }

    public static void main(String[] args) {
        NodeInfo nodeInfo_3_1_10 = new NodeInfo(10031010);
        NodeInfo nodeInfo_300_0_110 = new NodeInfo(43000110);
        System.out.println(nodeInfo_3_1_10.getDcName());
        System.out.println(nodeInfo_3_1_10.getNodeName());
        System.out.println(nodeInfo_3_1_10.getLoadWeight());
        System.out.println(nodeInfo_300_0_110.getDcName());
        System.out.println(nodeInfo_300_0_110.getGroupName());
        System.out.println(nodeInfo_300_0_110.getNodeName());
        System.out.println(nodeInfo_300_0_110.getLoadWeight());
    }
}

