/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.midlayer.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.extend.midlayer.utils.ByteBufferUtil;
import org.noggit.CharArr;
import org.noggit.JSONParser;
import org.noggit.JSONWriter;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static Logger logger = LoggerFactory.getLogger(Utils.class);
    public static final ScheduledThreadPoolExecutor scheduledTasks = new ScheduledThreadPoolExecutor(20, new NamedThreadFactory("MyScheduledTasks", 5));
    public static final ExecutorService shortTasksExcutor = Executors.newFixedThreadPool(20);
    public static final ExecutorService cleanBackUpDataTasksExcutor = Executors.newFixedThreadPool(System.getProperty("cleanBackUpDataTasksThreadCount") == null ? 10 : Integer.parseInt(System.getProperty("cleanBackUpDataTasksThreadCount")));
    private static final ThreadLocal<MessageDigest> localMD5Digest = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            return Utils.newMessageDigest("MD5");
        }

        @Override
        public MessageDigest get() {
            MessageDigest digest = (MessageDigest)super.get();
            digest.reset();
            return digest;
        }
    };

    public static Properties loadPropertiesFileFromClassPath(String propertiesFileName) {
        Properties properties = new Properties();
        InputStream stream = null;
        try {
            stream = Utils.class.getClassLoader().getResourceAsStream(propertiesFileName);
            properties.load(stream);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Unable to read " + propertiesFileName, e);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(stream);
                throw throwable;
            }
        }
        Utils.closeQuietly(stream);
        return properties;
    }

    public static String getFilePathFromClassPath(String filename) {
        ClassLoader loader = Utils.class.getClassLoader();
        URL scpurl = loader.getResource(filename);
        if (scpurl == null) {
            throw new RuntimeException("unable to locate " + filename);
        }
        return scpurl.getFile();
    }

    public static void closeQuietly(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception e) {
            logger.warn("Failed closing " + c, (Throwable)e);
        }
    }

    public static byte[] joinBytebuffers(ByteBuffer[] bytebuffers) {
        int sizeOfvalueSerialized = Utils.sum(bytebuffers);
        byte[] valueJoined = new byte[sizeOfvalueSerialized];
        int desOffset = 0;
        for (int i = 0; i < bytebuffers.length; ++i) {
            ByteBufferUtil.arrayCopy(bytebuffers[i], bytebuffers[i].position(), valueJoined, desOffset, bytebuffers[i].remaining());
            desOffset += bytebuffers[i].remaining();
        }
        return valueJoined;
    }

    public static int sum(ByteBuffer[] bytebuffers) {
        int sum = 0;
        for (int i = 0; i < bytebuffers.length; ++i) {
            sum += bytebuffers[i].remaining();
        }
        return sum;
    }

    public static boolean portIsBindOnLookbackAndAnyInteAddresses(int port) {
        String[] allIPsOfLocal;
        for (String ip : allIPsOfLocal = new String[]{"127.0.0.1", "0.0.0.0"}) {
            if (!Utils.socketAddressIsBind(ip, port)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean socketAddressIsBind(String ip, int port) {
        Socket bindServer = new Socket();
        InetSocketAddress address = new InetSocketAddress(ip, port);
        try {
            bindServer.bind(address);
        }
        catch (IOException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                bindServer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public static <T> T notNull(T t, String message) {
        String new_name;
        if (t == null) {
            throw new IllegalArgumentException(message);
        }
        if (t instanceof String && (new_name = (String)t).length() <= 0) {
            throw new IllegalArgumentException(message);
        }
        return t;
    }

    public static long makeLong(byte[] bytes) {
        if (bytes.length != 8) {
            throw new RuntimeException("illegal bytes length:" + bytes.length);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        return byteBuffer.getLong(byteBuffer.position());
    }

    public static synchronized InetAddress getLocalHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static byte[] toJSON(Object o) {
        CharArr out = new CharArr();
        new JSONWriter(out, 2).write(o);
        return Utils.toUTF8(out);
    }

    private static byte[] toUTF8(CharArr out) {
        byte[] arr = new byte[out.size() << 2];
        int nBytes = Utils.UTF16toUTF8((CharSequence)out, 0, out.size(), arr, 0);
        return Arrays.copyOf(arr, nBytes);
    }

    public static Object fromJSON(byte[] utf8) {
        CharArr chars = new CharArr();
        Utils.UTF8toUTF16(utf8, 0, utf8.length, chars);
        JSONParser parser = new JSONParser(chars.getArray(), chars.getStart(), chars.length());
        try {
            return ObjectBuilder.getVal((JSONParser)parser);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int UTF8toUTF16(byte[] utf8, int offset, int len, char[] out, int out_offset) {
        int out_start = out_offset;
        int limit = offset + len;
        while (offset < limit) {
            int b;
            if ((b = utf8[offset++] & 0xFF) < 192) {
                assert (b < 128);
                out[out_offset++] = (char)b;
                continue;
            }
            if (b < 224) {
                out[out_offset++] = (char)(((b & 0x1F) << 6) + (utf8[offset++] & 0x3F));
                continue;
            }
            if (b < 240) {
                out[out_offset++] = (char)(((b & 0xF) << 12) + ((utf8[offset] & 0x3F) << 6) + (utf8[offset + 1] & 0x3F));
                offset += 2;
                continue;
            }
            assert (b < 248);
            int ch = ((b & 7) << 18) + ((utf8[offset] & 0x3F) << 12) + ((utf8[offset + 1] & 0x3F) << 6) + (utf8[offset + 2] & 0x3F);
            offset += 3;
            if (ch < 65535) {
                out[out_offset++] = (char)ch;
                continue;
            }
            int chHalf = ch - 65536;
            out[out_offset++] = (char)((chHalf >> 10) + 55296);
            out[out_offset++] = (char)(((long)chHalf & 0x3FFL) + 56320L);
        }
        return out_offset - out_start;
    }

    private static void UTF8toUTF16(byte[] utf8, int offset, int len, CharArr out) {
        out.reserve(len);
        int n = Utils.UTF8toUTF16(utf8, offset, len, out.getArray(), out.getEnd());
        out.setEnd(out.getEnd() + n);
    }

    public static String UTF8toUTF16(byte[] utf8, int offset, int len) {
        char[] out = new char[len];
        int n = Utils.UTF8toUTF16(utf8, offset, len, out, 0);
        return new String(out, 0, n);
    }

    private static int UTF16toUTF8(CharSequence s, int offset, int len, byte[] result, int resultOffset) {
        int end = offset + len;
        int upto = resultOffset;
        for (int i = offset; i < end; ++i) {
            int utf32;
            char code = s.charAt(i);
            if (code < '\u0080') {
                result[upto++] = (byte)code;
                continue;
            }
            if (code < '\u0800') {
                result[upto++] = (byte)(0xC0 | code >> 6);
                result[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\ud800' || code > '\udfff') {
                result[upto++] = (byte)(0xE0 | code >> 12);
                result[upto++] = (byte)(0x80 | code >> 6 & 0x3F);
                result[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\udc00' && i < end - 1 && (utf32 = s.charAt(i + 1)) >= 56320 && utf32 <= 57343) {
                utf32 = (code - 55232 << 10) + (utf32 & 0x3FF);
                ++i;
                result[upto++] = (byte)(0xF0 | utf32 >> 18);
                result[upto++] = (byte)(0x80 | utf32 >> 12 & 0x3F);
                result[upto++] = (byte)(0x80 | utf32 >> 6 & 0x3F);
                result[upto++] = (byte)(0x80 | utf32 & 0x3F);
                continue;
            }
            result[upto++] = -17;
            result[upto++] = -65;
            result[upto++] = -67;
        }
        return upto - resultOffset;
    }

    public static boolean isTestingCheckTable(String database, String table) {
        return "test".equals(database) && ("checkTableForNodeUsable".equals(table) || "checkTableForDCUsable".equals(table));
    }

    private static MessageDigest newMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("the requested digest algorithm (" + algorithm + ") is not available", nsae);
        }
    }

    public static String calculateMD5(ByteBuffer bytes) {
        MessageDigest messageDigest = localMD5Digest.get();
        messageDigest.update(bytes.duplicate());
        return ByteBufferUtil.bytesToHex(ByteBuffer.wrap(messageDigest.digest()));
    }

    public static void checkMD5Code(String md5Code) {
        if (md5Code == null) {
            throw new RuntimeException("md5Code should not be null!");
        }
        if (md5Code.length() != 32) {
            throw new RuntimeException("md5Code should not be 32 chars!");
        }
        ByteBufferUtil.hexToBytes(md5Code);
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        protected final String id;
        private final int priority;
        protected final AtomicInteger n = new AtomicInteger(1);

        public NamedThreadFactory(String id, int priority) {
            this.id = id;
            this.priority = priority;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            String name = this.id + ":" + this.n.getAndIncrement();
            Thread thread = new Thread(runnable, name);
            thread.setPriority(this.priority);
            thread.setDaemon(true);
            return thread;
        }
    }
}

