/*
 * Decompiled with CFR 0.152.
 */
package hector.com.google.common.base;

import hector.com.google.common.annotations.Beta;
import hector.com.google.common.annotations.GwtCompatible;
import hector.com.google.common.base.Function;
import hector.com.google.common.base.Preconditions;

@GwtCompatible
@Beta
public final class Enums {
    private Enums() {
    }

    public static <T extends Enum<T>> Function<String, T> valueOfFunction(Class<T> enumClass) {
        return new ValueOfFunction(enumClass);
    }

    private static final class ValueOfFunction<T extends Enum<T>>
    implements Function<String, T> {
        private final Class<T> enumClass;

        private ValueOfFunction(Class<T> enumClass) {
            this.enumClass = Preconditions.checkNotNull(enumClass);
        }

        @Override
        public T apply(String value) {
            try {
                return Enum.valueOf(this.enumClass, value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

