/*
 * Decompiled with CFR 0.152.
 */
package hector.com.google.common.base;

import hector.com.google.common.annotations.Beta;
import hector.com.google.common.annotations.GwtCompatible;
import hector.com.google.common.base.Equivalence;
import hector.com.google.common.base.PairwiseEquivalence;
import javax.annotation.Nullable;

@Beta
@GwtCompatible
public final class Equivalences {
    private Equivalences() {
    }

    public static Equivalence<Object> equals() {
        return Impl.EQUALS;
    }

    public static Equivalence<Object> identity() {
        return Impl.IDENTITY;
    }

    @GwtCompatible(serializable=true)
    public static <T> Equivalence<Iterable<T>> pairwise(Equivalence<? super T> elementEquivalence) {
        return new PairwiseEquivalence<T>(elementEquivalence);
    }

    private static enum Impl implements Equivalence<Object>
    {
        EQUALS{

            @Override
            public boolean equivalent(@Nullable Object a, @Nullable Object b) {
                return a == null ? b == null : a.equals(b);
            }

            @Override
            public int hash(@Nullable Object o) {
                return o == null ? 0 : o.hashCode();
            }
        }
        ,
        IDENTITY{

            @Override
            public boolean equivalent(@Nullable Object a, @Nullable Object b) {
                return a == b;
            }

            @Override
            public int hash(@Nullable Object o) {
                return System.identityHashCode(o);
            }
        };

    }
}

