/*
 * Decompiled with CFR 0.152.
 */
package hector.com.google.common.collect;

import hector.com.google.common.annotations.Beta;
import hector.com.google.common.annotations.GwtCompatible;
import hector.com.google.common.annotations.GwtIncompatible;
import hector.com.google.common.base.Ascii;
import hector.com.google.common.base.Equivalence;
import hector.com.google.common.base.Function;
import hector.com.google.common.base.Objects;
import hector.com.google.common.base.Preconditions;
import hector.com.google.common.base.Ticker;
import hector.com.google.common.collect.ComputationException;
import hector.com.google.common.collect.ComputingConcurrentHashMap;
import hector.com.google.common.collect.CustomConcurrentHashMap;
import hector.com.google.common.collect.ForwardingConcurrentMap;
import hector.com.google.common.collect.GenericMapMaker;
import hector.com.google.common.collect.MapEvictionListener;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@GwtCompatible(emulated=true)
public final class MapMaker
extends GenericMapMaker<Object, Object> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 4;
    private static final int DEFAULT_EXPIRATION_NANOS = 0;
    static final Executor DEFAULT_CLEANUP_EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable r) {
            r.run();
        }
    };
    static final Ticker DEFAULT_TICKER = new Ticker(){

        @Override
        public long read() {
            return System.nanoTime();
        }
    };
    static final int UNSET_INT = -1;
    int initialCapacity = -1;
    int concurrencyLevel = -1;
    int maximumSize = -1;
    CustomConcurrentHashMap.Strength keyStrength;
    CustomConcurrentHashMap.Strength valueStrength;
    long expireAfterWriteNanos = -1L;
    long expireAfterAccessNanos = -1L;
    boolean useCustomMap;
    boolean useNullMap;
    Equivalence<Object> keyEquivalence;
    Equivalence<Object> valueEquivalence;
    Executor cleanupExecutor;
    Ticker ticker;

    MapMaker privateKeyEquivalence(Equivalence<Object> equivalence) {
        Preconditions.checkState(this.keyEquivalence == null, "key equivalence was already set to %s", this.keyEquivalence);
        this.keyEquivalence = Preconditions.checkNotNull(equivalence);
        this.useCustomMap = true;
        return this;
    }

    Equivalence<Object> getKeyEquivalence() {
        return Objects.firstNonNull(this.keyEquivalence, this.getKeyStrength().defaultEquivalence());
    }

    MapMaker privateValueEquivalence(Equivalence<Object> equivalence) {
        Preconditions.checkState(this.valueEquivalence == null, "value equivalence was already set to %s", this.valueEquivalence);
        this.valueEquivalence = Preconditions.checkNotNull(equivalence);
        this.useCustomMap = true;
        return this;
    }

    Equivalence<Object> getValueEquivalence() {
        return Objects.firstNonNull(this.valueEquivalence, this.getValueStrength().defaultEquivalence());
    }

    public MapMaker initialCapacity(int initialCapacity) {
        Preconditions.checkState(this.initialCapacity == -1, "initial capacity was already set to %s", this.initialCapacity);
        Preconditions.checkArgument(initialCapacity >= 0);
        this.initialCapacity = initialCapacity;
        return this;
    }

    int getInitialCapacity() {
        return this.initialCapacity == -1 ? 16 : this.initialCapacity;
    }

    @Beta
    public MapMaker maximumSize(int size) {
        Preconditions.checkState(this.maximumSize == -1, "maximum size was already set to %s", this.maximumSize);
        Preconditions.checkArgument(size >= 0, "maximum size must not be negative");
        this.maximumSize = size;
        this.useCustomMap = true;
        this.useNullMap |= this.maximumSize == 0;
        return this;
    }

    @GwtIncompatible(value="java.util.concurrent.ConcurrentHashMap concurrencyLevel")
    public MapMaker concurrencyLevel(int concurrencyLevel) {
        Preconditions.checkState(this.concurrencyLevel == -1, "concurrency level was already set to %s", this.concurrencyLevel);
        Preconditions.checkArgument(concurrencyLevel > 0);
        this.concurrencyLevel = concurrencyLevel;
        return this;
    }

    int getConcurrencyLevel() {
        return this.concurrencyLevel == -1 ? 4 : this.concurrencyLevel;
    }

    @GwtIncompatible(value="java.lang.ref.WeakReference")
    public MapMaker weakKeys() {
        return this.setKeyStrength(CustomConcurrentHashMap.Strength.WEAK);
    }

    @GwtIncompatible(value="java.lang.ref.SoftReference")
    public MapMaker softKeys() {
        return this.setKeyStrength(CustomConcurrentHashMap.Strength.SOFT);
    }

    MapMaker setKeyStrength(CustomConcurrentHashMap.Strength strength) {
        Preconditions.checkState(this.keyStrength == null, "Key strength was already set to %s", new Object[]{this.keyStrength});
        this.keyStrength = Preconditions.checkNotNull(strength);
        if (strength != CustomConcurrentHashMap.Strength.STRONG) {
            this.useCustomMap = true;
        }
        return this;
    }

    CustomConcurrentHashMap.Strength getKeyStrength() {
        return Objects.firstNonNull(this.keyStrength, CustomConcurrentHashMap.Strength.STRONG);
    }

    @GwtIncompatible(value="java.lang.ref.WeakReference")
    public MapMaker weakValues() {
        return this.setValueStrength(CustomConcurrentHashMap.Strength.WEAK);
    }

    @GwtIncompatible(value="java.lang.ref.SoftReference")
    public MapMaker softValues() {
        return this.setValueStrength(CustomConcurrentHashMap.Strength.SOFT);
    }

    MapMaker setValueStrength(CustomConcurrentHashMap.Strength strength) {
        Preconditions.checkState(this.valueStrength == null, "Value strength was already set to %s", new Object[]{this.valueStrength});
        this.valueStrength = Preconditions.checkNotNull(strength);
        if (strength != CustomConcurrentHashMap.Strength.STRONG) {
            this.useCustomMap = true;
        }
        return this;
    }

    CustomConcurrentHashMap.Strength getValueStrength() {
        return Objects.firstNonNull(this.valueStrength, CustomConcurrentHashMap.Strength.STRONG);
    }

    @Deprecated
    public MapMaker expiration(long duration, TimeUnit unit) {
        return this.expireAfterWrite(duration, unit);
    }

    @Beta
    public MapMaker expireAfterWrite(long duration, TimeUnit unit) {
        this.checkExpiration(duration, unit);
        this.expireAfterWriteNanos = unit.toNanos(duration);
        this.useNullMap |= duration == 0L;
        this.useCustomMap = true;
        return this;
    }

    private void checkExpiration(long duration, TimeUnit unit) {
        Preconditions.checkState(this.expireAfterWriteNanos == -1L, "expireAfterWrite was already set to %s ns", this.expireAfterWriteNanos);
        Preconditions.checkState(this.expireAfterAccessNanos == -1L, "expireAfterAccess was already set to %s ns", this.expireAfterAccessNanos);
        Preconditions.checkArgument(duration >= 0L, "duration cannot be negative: %s %s", new Object[]{duration, unit});
    }

    long getExpireAfterWriteNanos() {
        return this.expireAfterWriteNanos == -1L ? 0L : this.expireAfterWriteNanos;
    }

    @Beta
    @GwtIncompatible(value="To be supported")
    public MapMaker expireAfterAccess(long duration, TimeUnit unit) {
        this.checkExpiration(duration, unit);
        this.expireAfterAccessNanos = unit.toNanos(duration);
        this.useNullMap |= duration == 0L;
        this.useCustomMap = true;
        return this;
    }

    long getExpireAfterAccessNanos() {
        return this.expireAfterAccessNanos == -1L ? 0L : this.expireAfterAccessNanos;
    }

    Executor getCleanupExecutor() {
        return Objects.firstNonNull(this.cleanupExecutor, DEFAULT_CLEANUP_EXECUTOR);
    }

    Ticker getTicker() {
        return Objects.firstNonNull(this.ticker, DEFAULT_TICKER);
    }

    @Beta
    @GwtIncompatible(value="To be supported")
    public <K, V> GenericMapMaker<K, V> evictionListener(MapEvictionListener<K, V> listener) {
        Preconditions.checkState(this.evictionListener == null);
        MapMaker me = this;
        me.evictionListener = Preconditions.checkNotNull(listener);
        this.useCustomMap = true;
        return me;
    }

    <K, V> MapEvictionListener<K, V> getEvictionListener() {
        return this.evictionListener == null ? NullListener.INSTANCE : this.evictionListener;
    }

    @Override
    public <K, V> ConcurrentMap<K, V> makeMap() {
        if (!this.useCustomMap) {
            return new ConcurrentHashMap(this.getInitialCapacity(), 0.75f, this.getConcurrencyLevel());
        }
        return (ConcurrentMap)((Object)(this.useNullMap ? new NullConcurrentMap(this) : new CustomConcurrentHashMap(this)));
    }

    <K, V> Cache<K, V> makeCache(Function<? super K, ? extends V> computingFunction) {
        return (Cache)((Object)(this.useNullMap ? new NullComputingConcurrentMap<K, V>(this, computingFunction) : new ComputingConcurrentHashMap<K, V>(this, computingFunction)));
    }

    @Override
    public <K, V> ConcurrentMap<K, V> makeComputingMap(Function<? super K, ? extends V> computingFunction) {
        Cache<? super K, ? extends V> cache = this.makeCache(computingFunction);
        return new ComputingMapAdapter<K, V>(cache);
    }

    public String toString() {
        Objects.ToStringHelper s = Objects.toStringHelper(this);
        if (this.initialCapacity != -1) {
            s.add("initialCapacity", this.initialCapacity);
        }
        if (this.concurrencyLevel != -1) {
            s.add("concurrencyLevel", this.concurrencyLevel);
        }
        if (this.maximumSize != -1) {
            s.add("maximumSize", this.maximumSize);
        }
        if (this.expireAfterWriteNanos != -1L) {
            s.add("expireAfterWrite", this.expireAfterWriteNanos + "ns");
        }
        if (this.expireAfterAccessNanos != -1L) {
            s.add("expireAfterAccess", this.expireAfterAccessNanos + "ns");
        }
        if (this.keyStrength != null) {
            s.add("keyStrength", Ascii.toLowerCase(this.keyStrength.toString()));
        }
        if (this.valueStrength != null) {
            s.add("valueStrength", Ascii.toLowerCase(this.valueStrength.toString()));
        }
        if (this.keyEquivalence != null) {
            s.addValue("keyEquivalence");
        }
        if (this.valueEquivalence != null) {
            s.addValue("valueEquivalence");
        }
        if (this.evictionListener != null) {
            s.addValue("evictionListener");
        }
        if (this.cleanupExecutor != null) {
            s.addValue("cleanupExecutor");
        }
        return s.toString();
    }

    static class ComputingMapAdapter<K, V>
    extends ForwardingConcurrentMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        final Cache<K, V> cache;

        ComputingMapAdapter(Cache<K, V> cache) {
            this.cache = cache;
        }

        @Override
        protected ConcurrentMap<K, V> delegate() {
            return this.cache.asMap();
        }

        @Override
        public V get(Object key) {
            return (V)this.cache.apply(key);
        }
    }

    static final class NullComputingConcurrentMap<K, V>
    extends NullConcurrentMap<K, V>
    implements Cache<K, V> {
        private static final long serialVersionUID = 0L;
        final Function<? super K, ? extends V> computingFunction;

        NullComputingConcurrentMap(MapMaker mapMaker, Function<? super K, ? extends V> computingFunction) {
            super(mapMaker);
            this.computingFunction = Preconditions.checkNotNull(computingFunction);
        }

        @Override
        public V apply(K key) {
            V value = this.compute(key);
            Preconditions.checkNotNull(value, this.computingFunction + " returned null for key " + key + ".");
            this.evictionListener.onEviction(key, value);
            return value;
        }

        private V compute(K key) {
            Preconditions.checkNotNull(key);
            try {
                return this.computingFunction.apply(key);
            }
            catch (ComputationException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ComputationException(t);
            }
        }

        @Override
        public ConcurrentMap<K, V> asMap() {
            return this;
        }
    }

    static class NullConcurrentMap<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 0L;
        final MapEvictionListener<K, V> evictionListener;

        NullConcurrentMap(MapMaker mapMaker) {
            this.evictionListener = mapMaker.getEvictionListener();
        }

        @Override
        public boolean containsKey(Object key) {
            Preconditions.checkNotNull(key);
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            Preconditions.checkNotNull(value);
            return false;
        }

        @Override
        public V get(Object key) {
            Preconditions.checkNotNull(key);
            return null;
        }

        @Override
        public V put(K key, V value) {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(value);
            this.evictionListener.onEviction(key, value);
            return null;
        }

        @Override
        public V putIfAbsent(K key, V value) {
            return this.put(key, value);
        }

        @Override
        public V remove(Object key) {
            Preconditions.checkNotNull(key);
            return null;
        }

        @Override
        public boolean remove(Object key, Object value) {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(value);
            return false;
        }

        @Override
        public V replace(K key, V value) {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(value);
            return null;
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(oldValue);
            Preconditions.checkNotNull(newValue);
            return false;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.emptySet();
        }
    }

    static interface Cache<K, V>
    extends Function<K, V> {
        public ConcurrentMap<K, V> asMap();
    }

    static enum NullListener implements MapEvictionListener
    {
        INSTANCE;


        public void onEviction(Object key, Object value) {
        }
    }
}

