/*
 * Decompiled with CFR 0.152.
 */
package hector.com.google.common.collect;

import hector.com.google.common.annotations.GwtCompatible;
import hector.com.google.common.annotations.GwtIncompatible;
import hector.com.google.common.collect.MapMaker;
import java.lang.reflect.Array;
import java.util.logging.Logger;

@GwtCompatible(emulated=true)
class Platform {
    private static final Logger logger = Logger.getLogger(Platform.class.getCanonicalName());

    static <T> T[] clone(T[] array) {
        return (Object[])array.clone();
    }

    static void unsafeArrayCopy(Object[] src, int srcPos, Object[] dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    static <T> T[] newArray(Class<T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    static <T> T[] newArray(T[] reference, int length) {
        Class<?> type = reference.getClass().getComponentType();
        Object[] result = (Object[])Array.newInstance(type, length);
        return result;
    }

    static MapMaker tryWeakKeys(MapMaker mapMaker) {
        return mapMaker.weakKeys();
    }

    private Platform() {
    }
}

