/*
 * Decompiled with CFR 0.152.
 */
package hector.com.google.common.util.concurrent;

import hector.com.google.common.annotations.Beta;
import hector.com.google.common.base.Preconditions;
import hector.com.google.common.base.Throwables;
import hector.com.google.common.util.concurrent.AbstractListenableFuture;
import hector.com.google.common.util.concurrent.Futures;
import hector.com.google.common.util.concurrent.ListenableFuture;
import hector.com.google.common.util.concurrent.Service;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;

@Beta
public abstract class AbstractService
implements Service {
    private final ReentrantLock lock = new ReentrantLock();
    private final Transition startup = new Transition();
    private final Transition shutdown = new Transition();
    private Service.State state = Service.State.NEW;
    private boolean shutdownWhenStartupFinishes = false;

    protected abstract void doStart();

    protected abstract void doStop();

    @Override
    public final ListenableFuture<Service.State> start() {
        this.lock.lock();
        try {
            if (this.state == Service.State.NEW) {
                this.state = Service.State.STARTING;
                this.doStart();
            }
        }
        catch (Throwable startupFailure) {
            this.notifyFailed(startupFailure);
        }
        finally {
            this.lock.unlock();
        }
        return this.startup;
    }

    @Override
    public final ListenableFuture<Service.State> stop() {
        this.lock.lock();
        try {
            if (this.state == Service.State.NEW) {
                this.state = Service.State.TERMINATED;
                this.startup.set(Service.State.TERMINATED);
                this.shutdown.set(Service.State.TERMINATED);
            } else if (this.state == Service.State.STARTING) {
                this.shutdownWhenStartupFinishes = true;
                this.startup.set(Service.State.STOPPING);
            } else if (this.state == Service.State.RUNNING) {
                this.state = Service.State.STOPPING;
                this.doStop();
            }
        }
        catch (Throwable shutdownFailure) {
            this.notifyFailed(shutdownFailure);
        }
        finally {
            this.lock.unlock();
        }
        return this.shutdown;
    }

    @Override
    public Service.State startAndWait() {
        try {
            return Futures.makeUninterruptible(this.start()).get();
        }
        catch (ExecutionException e) {
            throw Throwables.propagate(e.getCause());
        }
    }

    @Override
    public Service.State stopAndWait() {
        try {
            return Futures.makeUninterruptible(this.stop()).get();
        }
        catch (ExecutionException e) {
            throw Throwables.propagate(e.getCause());
        }
    }

    protected final void notifyStarted() {
        this.lock.lock();
        try {
            if (this.state != Service.State.STARTING) {
                IllegalStateException failure = new IllegalStateException("Cannot notifyStarted() when the service is " + (Object)((Object)this.state));
                this.notifyFailed(failure);
                throw failure;
            }
            this.state = Service.State.RUNNING;
            if (this.shutdownWhenStartupFinishes) {
                this.stop();
            } else {
                this.startup.set(Service.State.RUNNING);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected final void notifyStopped() {
        this.lock.lock();
        try {
            if (this.state != Service.State.STOPPING && this.state != Service.State.RUNNING) {
                IllegalStateException failure = new IllegalStateException("Cannot notifyStopped() when the service is " + (Object)((Object)this.state));
                this.notifyFailed(failure);
                throw failure;
            }
            this.state = Service.State.TERMINATED;
            this.shutdown.set(Service.State.TERMINATED);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected final void notifyFailed(Throwable cause) {
        Preconditions.checkNotNull(cause);
        this.lock.lock();
        try {
            if (this.state == Service.State.STARTING) {
                this.startup.setException(cause);
                this.shutdown.setException(new Exception("Service failed to start.", cause));
            } else if (this.state == Service.State.STOPPING) {
                this.shutdown.setException(cause);
            }
            this.state = Service.State.FAILED;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final boolean isRunning() {
        return this.state() == Service.State.RUNNING;
    }

    @Override
    public final Service.State state() {
        this.lock.lock();
        try {
            if (this.shutdownWhenStartupFinishes && this.state == Service.State.STARTING) {
                Service.State state = Service.State.STOPPING;
                return state;
            }
            Service.State state = this.state;
            return state;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + (Object)((Object)this.state()) + "]";
    }

    private class Transition
    extends AbstractListenableFuture<Service.State> {
        private Transition() {
        }

        @Override
        public Service.State get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
            try {
                return (Service.State)((Object)super.get(timeout, unit));
            }
            catch (TimeoutException e) {
                throw new TimeoutException(AbstractService.this.toString());
            }
        }
    }
}

