/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.connection;

import hector.com.google.common.collect.Lists;
import hector.com.google.common.collect.Maps;
import hector.me.prettyprint.cassandra.connection.HClientPool;
import hector.me.prettyprint.cassandra.connection.LatencyAwareHClientPool;
import hector.me.prettyprint.cassandra.connection.LoadBalancingPolicy;
import hector.me.prettyprint.cassandra.connection.factory.HClientFactory;
import hector.me.prettyprint.cassandra.service.CassandraHost;
import hector.me.prettyprint.cassandra.utils.DaemonThreadPoolFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicLoadBalancingPolicy
implements LoadBalancingPolicy {
    private static final long serialVersionUID = -1044985880174118325L;
    private static final Log log = LogFactory.getLog(DynamicLoadBalancingPolicy.class);
    private final ScheduledExecutorService tasks = new ScheduledThreadPoolExecutor(1, new DaemonThreadPoolFactory(this.getClass()));
    private Map<HClientPool, Double> scores = Maps.newConcurrentMap();
    private List<LatencyAwareHClientPool> allPools = new CopyOnWriteArrayList<LatencyAwareHClientPool>();
    private int UPDATE_INTERVAL = 100;
    private int RESET_INTERVAL = 20000;
    private double DYNAMIC_BADNESS_THRESHOLD = 0.1;

    public DynamicLoadBalancingPolicy() {
        Runnable updateThread = new Runnable(){

            @Override
            public void run() {
                try {
                    DynamicLoadBalancingPolicy.this.updateScores();
                }
                catch (Exception e) {
                    log.info((Object)"exception updating scores", (Throwable)e);
                }
            }
        };
        Runnable resetThread = new Runnable(){

            @Override
            public void run() {
                try {
                    for (LatencyAwareHClientPool pool : DynamicLoadBalancingPolicy.this.allPools) {
                        pool.clear();
                    }
                }
                catch (Exception e) {
                    log.info((Object)"exceotuib reseting stats", (Throwable)e);
                }
            }
        };
        this.tasks.scheduleWithFixedDelay(updateThread, this.UPDATE_INTERVAL, this.UPDATE_INTERVAL, TimeUnit.MILLISECONDS);
        this.tasks.scheduleWithFixedDelay(resetThread, this.RESET_INTERVAL, this.RESET_INTERVAL, TimeUnit.MILLISECONDS);
    }

    @Override
    public HClientPool getPool(Collection<HClientPool> pools, Set<CassandraHost> excludeHosts) {
        ArrayList<HClientPool> poolList = Lists.newArrayList(pools);
        if (excludeHosts != null) {
            this.filter(poolList, excludeHosts);
        }
        Collections.shuffle(poolList);
        HClientPool fp = (HClientPool)poolList.get(0);
        Double first = this.scores.get(fp);
        for (int i = 1; i < poolList.size(); ++i) {
            HClientPool np = (HClientPool)poolList.get(i);
            Double next = this.scores.get(np);
            if (!((first - next) / first > this.DYNAMIC_BADNESS_THRESHOLD)) continue;
            Collections.sort(poolList, new SortByScoreComparator());
            if (!log.isDebugEnabled()) break;
            log.debug((Object)String.format("According to score we have chosen %s vs first %s", poolList.get(0), fp));
            break;
        }
        return (HClientPool)poolList.get(0);
    }

    private void filter(List<HClientPool> from, Set<CassandraHost> subList) {
        Iterator<HClientPool> it = from.iterator();
        while (it.hasNext()) {
            if (!subList.contains(it.next().getCassandraHost())) continue;
            it.remove();
        }
    }

    @Override
    public HClientPool createConnection(HClientFactory clientFactory, CassandraHost host) {
        LatencyAwareHClientPool pool = new LatencyAwareHClientPool(clientFactory, host);
        this.add(pool);
        return pool;
    }

    void add(LatencyAwareHClientPool pool) {
        this.allPools.add(pool);
        this.scores.put(pool, 0.0);
    }

    void updateScores() {
        for (LatencyAwareHClientPool pool : this.allPools) {
            this.scores.put(pool, pool.score());
            pool.resetIntervel();
        }
    }

    public int getUpdateInterval() {
        return this.UPDATE_INTERVAL;
    }

    public void setUpdateInterval(int updateInterval) {
        this.UPDATE_INTERVAL = updateInterval;
    }

    public int getResetInterval() {
        return this.RESET_INTERVAL;
    }

    public void setResetInterval(int resetInterval) {
        this.RESET_INTERVAL = resetInterval;
    }

    public double getBadnessThreshold() {
        return this.DYNAMIC_BADNESS_THRESHOLD;
    }

    public void setBadnessThreshold(double badness) {
        this.DYNAMIC_BADNESS_THRESHOLD = badness;
    }

    private class SortByScoreComparator
    implements Comparator<HClientPool> {
        private SortByScoreComparator() {
        }

        @Override
        public int compare(HClientPool p1, HClientPool p2) {
            Double scored2;
            Double scored1 = (Double)DynamicLoadBalancingPolicy.this.scores.get(p1);
            if (scored1.equals(scored2 = (Double)DynamicLoadBalancingPolicy.this.scores.get(p2))) {
                return 0;
            }
            if (scored1 < scored2) {
                return -1;
            }
            return 1;
        }
    }
}

