/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.connection;

import hector.me.prettyprint.cassandra.connection.CassandraHostRetryService;
import hector.me.prettyprint.cassandra.connection.ConnectionManagerListener;
import hector.me.prettyprint.cassandra.connection.ConnectionManagerListenersHandler;
import hector.me.prettyprint.cassandra.connection.HClientPool;
import hector.me.prettyprint.cassandra.connection.HOpTimer;
import hector.me.prettyprint.cassandra.connection.HostTimeoutTracker;
import hector.me.prettyprint.cassandra.connection.LoadBalancingPolicy;
import hector.me.prettyprint.cassandra.connection.NodeAutoDiscoverService;
import hector.me.prettyprint.cassandra.connection.client.HClient;
import hector.me.prettyprint.cassandra.connection.factory.HClientFactory;
import hector.me.prettyprint.cassandra.connection.factory.HClientFactoryProvider;
import hector.me.prettyprint.cassandra.service.CassandraClientMonitor;
import hector.me.prettyprint.cassandra.service.CassandraHost;
import hector.me.prettyprint.cassandra.service.CassandraHostConfigurator;
import hector.me.prettyprint.cassandra.service.ExceptionsTranslator;
import hector.me.prettyprint.cassandra.service.ExceptionsTranslatorImpl;
import hector.me.prettyprint.cassandra.service.FailoverPolicy;
import hector.me.prettyprint.cassandra.service.JmxMonitor;
import hector.me.prettyprint.cassandra.service.Operation;
import hector.me.prettyprint.hector.api.ClockResolution;
import hector.me.prettyprint.hector.api.exceptions.HCassandraInternalException;
import hector.me.prettyprint.hector.api.exceptions.HInvalidRequestException;
import hector.me.prettyprint.hector.api.exceptions.HPoolRecoverableException;
import hector.me.prettyprint.hector.api.exceptions.HTimedOutException;
import hector.me.prettyprint.hector.api.exceptions.HUnavailableException;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.exceptions.HectorTransportException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HConnectionManager {
    private static final Log log = LogFactory.getLog(HConnectionManager.class);
    private final ConcurrentMap<CassandraHost, HClientPool> hostPools;
    private final ConcurrentMap<CassandraHost, HClientPool> suspendedHostPools;
    private final Collection<HClientPool> hostPoolValues;
    private final String clusterName;
    private CassandraHostRetryService cassandraHostRetryService;
    private NodeAutoDiscoverService nodeAutoDiscoverService;
    private final LoadBalancingPolicy loadBalancingPolicy;
    private final CassandraHostConfigurator cassandraHostConfigurator;
    private final HClientFactory clientFactory;
    private HostTimeoutTracker hostTimeoutTracker;
    private final ClockResolution clock;
    final ExceptionsTranslator exceptionsTranslator;
    private final CassandraClientMonitor monitor;
    private HOpTimer timer;
    private ConnectionManagerListenersHandler listenerHandler = new ConnectionManagerListenersHandler();

    public HConnectionManager(String clusterName, CassandraHostConfigurator cassandraHostConfigurator) {
        this.clientFactory = HClientFactoryProvider.createFactory(cassandraHostConfigurator);
        this.loadBalancingPolicy = cassandraHostConfigurator.getLoadBalancingPolicy();
        this.clock = cassandraHostConfigurator.getClockResolution();
        this.hostPools = new ConcurrentHashMap<CassandraHost, HClientPool>();
        this.suspendedHostPools = new ConcurrentHashMap<CassandraHost, HClientPool>();
        this.clusterName = clusterName;
        if (cassandraHostConfigurator.getRetryDownedHosts()) {
            this.cassandraHostRetryService = new CassandraHostRetryService(this, this.clientFactory, cassandraHostConfigurator, this.listenerHandler);
        }
        for (CassandraHost host : cassandraHostConfigurator.buildCassandraHosts()) {
            try {
                HClientPool hcp = this.loadBalancingPolicy.createConnection(this.clientFactory, host);
                this.hostPools.put(host, hcp);
            }
            catch (HectorTransportException hte) {
                log.warn((Object)String.format("Could not start connection pool for host %s", host));
                this.listenerHandler.fireOnHostDown(host);
                if (this.cassandraHostRetryService == null) continue;
                this.cassandraHostRetryService.add(host);
            }
        }
        if (cassandraHostConfigurator.getUseHostTimeoutTracker()) {
            this.hostTimeoutTracker = new HostTimeoutTracker(this, cassandraHostConfigurator);
        }
        this.monitor = JmxMonitor.getInstance().getCassandraMonitor(this);
        this.exceptionsTranslator = new ExceptionsTranslatorImpl();
        this.cassandraHostConfigurator = cassandraHostConfigurator;
        this.hostPoolValues = this.hostPools.values();
        if (cassandraHostConfigurator.getAutoDiscoverHosts()) {
            this.nodeAutoDiscoverService = new NodeAutoDiscoverService(this, cassandraHostConfigurator);
        }
        this.timer = cassandraHostConfigurator.getOpTimer();
    }

    public void doAddNodes() {
        if (this.nodeAutoDiscoverService != null) {
            this.nodeAutoDiscoverService.doAddNodes();
        } else {
            log.warn((Object)String.format("unable to add nodes, nodeAutoDiscoverService was null.  CassandraHostConfigurator.autoDiscoverHosts is %s", this.cassandraHostConfigurator.getAutoDiscoverHosts()));
        }
    }

    public boolean addCassandraHost(CassandraHost cassandraHost) {
        if (!this.getHosts().contains(cassandraHost)) {
            HClientPool pool = null;
            try {
                this.cassandraHostConfigurator.applyConfig(cassandraHost);
                pool = this.cassandraHostConfigurator.getLoadBalancingPolicy().createConnection(this.clientFactory, cassandraHost);
                this.hostPools.putIfAbsent(cassandraHost, pool);
                log.info((Object)String.format("Added host %s to pool", cassandraHost.getName()));
                this.listenerHandler.fireOnAddHost(cassandraHost, true, null, null);
                return true;
            }
            catch (HectorTransportException hte) {
                String errorMessage = "Transport exception host to HConnectionManager: " + cassandraHost;
                log.warn((Object)errorMessage, (Throwable)hte);
                this.listenerHandler.fireOnAddHost(cassandraHost, false, errorMessage, hte);
            }
            catch (Exception ex) {
                String errorMessage = "General exception host to HConnectionManager: " + cassandraHost;
                log.warn((Object)errorMessage, (Throwable)ex);
                this.listenerHandler.fireOnAddHost(cassandraHost, false, errorMessage, ex);
            }
        } else {
            String message = "Host already existed for pool " + cassandraHost.getName();
            log.info((Object)message);
            this.listenerHandler.fireOnAddHost(cassandraHost, false, message, null);
        }
        return false;
    }

    public boolean removeCassandraHost(CassandraHost cassandraHost) {
        String message;
        boolean removed = this.getHosts().contains(cassandraHost);
        if (removed) {
            HClientPool pool = (HClientPool)this.hostPools.remove(cassandraHost);
            message = "Removed from hostPools";
            if (pool == null) {
                log.info((Object)String.format("removeCassandraHost looking for host %s in suspendedHostPools", cassandraHost));
                pool = (HClientPool)this.suspendedHostPools.remove(cassandraHost);
                message = "Removed from suspendedHostPools";
            }
            if (pool != null) {
                pool.shutdown();
            } else {
                removed = false;
                message = "Removed by another thread";
                log.info((Object)String.format("removeCassandraHost attempt miss for CassandraHost %s May have been beaten by another thread?", cassandraHost));
            }
        } else if (this.cassandraHostRetryService != null && this.cassandraHostRetryService.contains(cassandraHost)) {
            log.info((Object)String.format("Host %s not in active pools, but found in retry service.", cassandraHost));
            removed = this.cassandraHostRetryService.remove(cassandraHost);
            message = "Removed from Downed hosts";
        } else {
            message = "Host not found";
            log.info((Object)String.format("Remove requested on a host that was not found in active or disabled pools: %s", cassandraHost));
        }
        log.info((Object)String.format("Remove status for CassandraHost pool %s was %s", cassandraHost, removed));
        this.listenerHandler.fireOnRemoveHost(cassandraHost, removed, message);
        return removed;
    }

    public boolean suspendCassandraHost(CassandraHost cassandraHost) {
        boolean removed;
        HClientPool pool = (HClientPool)this.hostPools.remove(cassandraHost);
        boolean bl = removed = pool != null;
        if (removed) {
            this.suspendedHostPools.put(cassandraHost, pool);
        }
        this.listenerHandler.fireOnSuspendHost(cassandraHost, removed);
        log.info((Object)String.format("Suspend operation status was %s for CassandraHost %s", removed, cassandraHost));
        return removed;
    }

    public boolean unsuspendCassandraHost(CassandraHost cassandraHost) {
        boolean readded;
        HClientPool pool = (HClientPool)this.suspendedHostPools.remove(cassandraHost);
        boolean bl = readded = pool != null;
        if (readded) {
            boolean alreadyThere;
            boolean bl2 = alreadyThere = this.hostPools.putIfAbsent(cassandraHost, pool) != null;
            if (alreadyThere) {
                log.warn((Object)String.format("Unsuspend called on a pool that was already active for CassandraHost %s", cassandraHost));
                pool.shutdown();
            }
        }
        this.listenerHandler.fireOnUnSuspendHost(cassandraHost, readded);
        log.info((Object)String.format("UN-Suspend operation status was %s for CassandraHost %s", readded, cassandraHost));
        return readded;
    }

    public Set<CassandraHost> getSuspendedCassandraHosts() {
        return this.suspendedHostPools.keySet();
    }

    public Set<CassandraHost> getHosts() {
        return Collections.unmodifiableSet(this.hostPools.keySet());
    }

    public List<String> getStatusPerPool() {
        ArrayList<String> stats = new ArrayList<String>();
        for (HClientPool clientPool : this.hostPools.values()) {
            stats.add(clientPool.getStatusAsString());
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operateWithFailover(Operation<?> op) throws HectorException {
        Object timerToken = this.timer.start();
        int retries = Math.min(op.failoverPolicy.numRetries, this.hostPools.size());
        HClient client = null;
        HClientPool pool = null;
        boolean success = false;
        boolean retryable = false;
        HashSet<CassandraHost> excludeHosts = new HashSet<CassandraHost>();
        while (!success) {
            try {
                pool = this.getClientFromLBPolicy(excludeHosts);
                client = pool.borrowClient();
                Cassandra.Client c = client.getCassandra(op.keyspaceName);
                if (op.credentials != null && !op.credentials.isEmpty() && !client.isAlreadyAuthenticated(op.credentials)) {
                    c.login(new AuthenticationRequest(op.credentials));
                    client.setAuthenticated(op.credentials);
                }
                op.executeAndSetResult(c, pool.getCassandraHost());
                success = true;
                this.timer.stop(timerToken, op.stopWatchTagName, true);
                break;
            }
            catch (Exception ex) {
                HectorException he = this.exceptionsTranslator.translate(ex);
                if (he instanceof HUnavailableException) {
                    throw he;
                }
                if (he instanceof HInvalidRequestException || he instanceof HCassandraInternalException) {
                    if (he instanceof HInvalidRequestException) {
                        if (!(he.getMessage() != null && he.getMessage().contains("bdb_read_not_exist") || he.getCause() != null && he.getCause().getMessage() != null && he.getCause().getMessage().contains("bdb_read_not_exist"))) {
                            this.closeClient(client);
                        }
                    } else {
                        this.closeClient(client);
                    }
                    throw he;
                }
                if (he instanceof HectorTransportException) {
                    this.closeClient(client);
                    this.markHostAsDown(pool.getCassandraHost());
                    excludeHosts.add(pool.getCassandraHost());
                    retryable = true;
                    this.monitor.incCounter(CassandraClientMonitor.Counter.RECOVERABLE_TRANSPORT_EXCEPTIONS);
                } else if (he instanceof HTimedOutException) {
                    this.doTimeoutCheck(pool.getCassandraHost());
                    retryable = true;
                    this.monitor.incCounter(CassandraClientMonitor.Counter.RECOVERABLE_TIMED_OUT_EXCEPTIONS);
                    client.close();
                } else if (he instanceof HPoolRecoverableException) {
                    retryable = true;
                    if (this.hostPools.size() == 1) {
                        throw he;
                    }
                    this.monitor.incCounter(CassandraClientMonitor.Counter.POOL_EXHAUSTED);
                    excludeHosts.add(pool.getCassandraHost());
                } else {
                    retryable = false;
                }
                if (retries <= 0 || !retryable) {
                    throw he;
                }
                log.warn((Object)String.format("Could not fullfill request on this host %s", client));
                log.warn((Object)"Exception: ", (Throwable)he);
                this.monitor.incCounter(CassandraClientMonitor.Counter.SKIP_HOST_SUCCESS);
                this.sleepBetweenHostSkips(op.failoverPolicy);
            }
            finally {
                --retries;
                if (!success) {
                    this.monitor.incCounter(op.failCounter);
                    this.timer.stop(timerToken, op.stopWatchTagName, false);
                }
                this.releaseClient(client);
            }
        }
    }

    private void closeClient(HClient client) {
        if (client != null) {
            client.close();
            client.clearAuthentication();
        }
    }

    public HOpTimer getTimer() {
        return this.timer;
    }

    public void setTimer(HOpTimer timer) {
        this.timer = timer;
    }

    public void addListener(String listenerName, ConnectionManagerListener listener) {
        this.listenerHandler.put(listenerName, listener);
    }

    public void removeListener(String listenerName) {
        this.listenerHandler.remove(listenerName);
    }

    public void removeAllListeners() {
        this.listenerHandler.clear();
    }

    private void doTimeoutCheck(CassandraHost cassandraHost) {
        if (this.hostTimeoutTracker != null && this.hostPools.size() > 1 && this.hostTimeoutTracker.checkTimeout(cassandraHost)) {
            this.suspendCassandraHost(cassandraHost);
        }
    }

    private void sleepBetweenHostSkips(FailoverPolicy failoverPolicy) {
        if (failoverPolicy.sleepBetweenHostsMilli > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Will sleep for %s millisec", failoverPolicy.sleepBetweenHostsMilli));
            }
            try {
                Thread.sleep(failoverPolicy.sleepBetweenHostsMilli);
            }
            catch (InterruptedException e) {
                log.warn((Object)"Sleep between hosts interrupted", (Throwable)e);
            }
        }
    }

    private HClientPool getClientFromLBPolicy(Set<CassandraHost> excludeHosts) {
        if (this.hostPools.isEmpty()) {
            StringBuffer hosts = new StringBuffer();
            for (CassandraHost host : this.cassandraHostRetryService.getDownedHosts()) {
                hosts.append(host.getName());
                hosts.append(",");
            }
            hosts.deleteCharAt(hosts.length() - 1);
            throw new HectorException("All host pools [" + hosts.toString() + "] marked down. Retry burden pushed out to client.");
        }
        return this.loadBalancingPolicy.getPool(this.hostPoolValues, excludeHosts);
    }

    void releaseClient(HClient client) {
        if (client == null) {
            return;
        }
        HClientPool pool = (HClientPool)this.hostPools.get(client.getCassandraHost());
        if (pool == null) {
            pool = (HClientPool)this.suspendedHostPools.get(client.getCassandraHost());
        }
        if (pool != null) {
            pool.releaseClient(client);
        } else {
            log.info((Object)String.format("Client %s released to inactive or dead pool. Closing.", client));
            client.close();
        }
    }

    HClient borrowClient() {
        HClientPool pool = this.getClientFromLBPolicy(null);
        if (pool != null) {
            return pool.borrowClient();
        }
        return null;
    }

    void markHostAsDown(CassandraHost cassandraHost) {
        log.warn((Object)String.format("MARK HOST AS DOWN TRIGGERED for host %s", cassandraHost.getName()));
        this.listenerHandler.fireOnHostDown(cassandraHost);
        HClientPool pool = (HClientPool)this.hostPools.remove(cassandraHost);
        if (pool != null) {
            log.warn((Object)String.format("Pool state on shutdown: %s", pool.getStatusAsString()));
            pool.shutdown();
            if (this.cassandraHostRetryService != null) {
                this.cassandraHostRetryService.add(cassandraHost);
            }
        }
    }

    public Set<CassandraHost> getDownedHosts() {
        return this.cassandraHostRetryService.getDownedHosts();
    }

    public Collection<HClientPool> getActivePools() {
        return Collections.unmodifiableCollection(this.hostPools.values());
    }

    public long createClock() {
        return this.clock.createClock();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void shutdown() {
        log.info((Object)"Shutdown called on HConnectionManager");
        if (this.cassandraHostRetryService != null) {
            this.cassandraHostRetryService.shutdown();
        }
        if (this.nodeAutoDiscoverService != null) {
            this.nodeAutoDiscoverService.shutdown();
        }
        if (this.hostTimeoutTracker != null) {
            this.hostTimeoutTracker.shutdown();
        }
        for (HClientPool pool : this.hostPools.values()) {
            try {
                pool.shutdown();
            }
            catch (IllegalArgumentException iae) {
                log.warn((Object)String.format("Out of order in HConnectionManager shutdown()?: %s", iae.getMessage()));
            }
        }
    }

    public void releaseIdleClientsForAllHostPools() {
        for (HClientPool pool : this.hostPools.values()) {
            pool.releaseIdleClients();
        }
    }
}

