/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.connection;

import hector.com.google.common.collect.Lists;
import hector.me.prettyprint.cassandra.connection.ConcurrentHClientPool;
import hector.me.prettyprint.cassandra.connection.HClientPool;
import hector.me.prettyprint.cassandra.connection.LoadBalancingPolicy;
import hector.me.prettyprint.cassandra.connection.factory.HClientFactory;
import hector.me.prettyprint.cassandra.service.CassandraHost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LeastActiveBalancingPolicy
implements LoadBalancingPolicy {
    private static final long serialVersionUID = 329849818218657061L;
    private static final Log log = LogFactory.getLog(LeastActiveBalancingPolicy.class);

    @Override
    public HClientPool getPool(Collection<HClientPool> pools, Set<CassandraHost> excludeHosts) {
        ArrayList<HClientPool> vals = Lists.newArrayList(pools);
        Collections.shuffle(vals);
        Collections.sort(vals, new ShufflingCompare());
        Iterator iterator = vals.iterator();
        HClientPool concurrentHClientPool = (HClientPool)iterator.next();
        if (excludeHosts != null && excludeHosts.size() > 0) {
            while (iterator.hasNext() && excludeHosts.contains(concurrentHClientPool.getCassandraHost())) {
                concurrentHClientPool = (ConcurrentHClientPool)iterator.next();
            }
        }
        return concurrentHClientPool;
    }

    @Override
    public HClientPool createConnection(HClientFactory clientFactory, CassandraHost host) {
        return new ConcurrentHClientPool(clientFactory, host);
    }

    private final class ShufflingCompare
    implements Comparator<HClientPool> {
        private ShufflingCompare() {
        }

        @Override
        public int compare(HClientPool o1, HClientPool o2) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("comparing 1: %s and count %s with 2: {} and count %s", o1.getCassandraHost(), o1.getNumActive(), o2.getCassandraHost(), o2.getNumActive()));
            }
            return o1.getNumActive() - o2.getNumActive();
        }
    }
}

