/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.connection;

import hector.me.prettyprint.cassandra.connection.BackgroundCassandraHostService;
import hector.me.prettyprint.cassandra.connection.HConnectionManager;
import hector.me.prettyprint.cassandra.service.CassandraHost;
import hector.me.prettyprint.cassandra.service.CassandraHostConfigurator;
import hector.me.prettyprint.cassandra.service.ThriftCluster;
import hector.me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import hector.me.prettyprint.hector.api.factory.HFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.thrift.EndpointDetails;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeAutoDiscoverService
extends BackgroundCassandraHostService {
    private static final Log log = LogFactory.getLog(NodeAutoDiscoverService.class);
    public static final int DEF_AUTO_DISCOVERY_DELAY = 30;
    private DataCenterValidator dataCenterValidator;

    public NodeAutoDiscoverService(HConnectionManager connectionManager, CassandraHostConfigurator cassandraHostConfigurator) {
        super(connectionManager, cassandraHostConfigurator);
        this.retryDelayInSeconds = cassandraHostConfigurator.getAutoDiscoveryDelayInSeconds();
        this.dataCenterValidator = new DataCenterValidator(cassandraHostConfigurator.getAutoDiscoveryDataCenters());
        this.sf = this.executor.scheduleWithFixedDelay(new QueryRing(), this.retryDelayInSeconds, this.retryDelayInSeconds, TimeUnit.SECONDS);
    }

    @Override
    void shutdown() {
        log.warn((Object)"Auto Discovery retry shutdown hook called");
        if (this.sf != null) {
            this.sf.cancel(true);
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        log.warn((Object)"AutoDiscovery retry shutdown complete");
    }

    @Override
    public void applyRetryDelay() {
    }

    public void doAddNodes() {
        Set<CassandraHost> foundHosts;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Auto discovery service running...");
        }
        if ((foundHosts = this.discoverNodes()) != null && foundHosts.size() > 0) {
            log.info((Object)String.format("Found %s new host(s) in Ring", foundHosts.size()));
            for (CassandraHost cassandraHost : foundHosts) {
                log.info((Object)String.format("Addding found host %s to pool", cassandraHost));
                this.cassandraHostConfigurator.applyConfig(cassandraHost);
                this.connectionManager.addCassandraHost(cassandraHost);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Auto discovery service run complete.");
        }
    }

    public Set<CassandraHost> discoverNodes() {
        Set<CassandraHost> existingHosts = this.connectionManager.getHosts();
        HashSet<CassandraHost> foundHosts = new HashSet<CassandraHost>();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("using existing hosts %s", existingHosts));
        }
        try {
            String clusterName = this.connectionManager.getClusterName();
            ThriftCluster cluster = (ThriftCluster)HFactory.getCluster(clusterName);
            for (KeyspaceDefinition keyspaceDefinition : cluster.describeKeyspaces()) {
                if (keyspaceDefinition.getName().equals("system")) continue;
                List<TokenRange> tokenRanges = cluster.describeRing(keyspaceDefinition.getName());
                for (TokenRange tokenRange : tokenRanges) {
                    for (EndpointDetails endPointDetail : tokenRange.getEndpoint_details()) {
                        CassandraHost foundHost;
                        if (!this.dataCenterValidator.validate(endPointDetail.getDatacenter()) || existingHosts.contains(foundHost = new CassandraHost(endPointDetail.getHost(), this.cassandraHostConfigurator.getPort()))) continue;
                        log.info((Object)String.format("Found a node we don't know about %s for TokenRange %s", foundHost, tokenRange));
                        foundHosts.add(foundHost);
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            log.warn((Object)"Discovery Service failed attempt to connect CassandraHost", (Throwable)e);
        }
        return foundHosts;
    }

    class DataCenterValidator {
        Set<String> dataCenters;

        public DataCenterValidator(List<String> dataCenters) {
            if (dataCenters != null) {
                this.dataCenters = new HashSet<String>(dataCenters);
            }
        }

        public boolean validate(String dcName) {
            if (this.dataCenters == null || dcName == null) {
                return true;
            }
            return this.dataCenters.contains(dcName);
        }
    }

    class QueryRing
    implements Runnable {
        QueryRing() {
        }

        @Override
        public void run() {
            NodeAutoDiscoverService.this.doAddNodes();
        }
    }
}

