/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.connection.client;

import hector.me.prettyprint.cassandra.connection.client.HClient;
import hector.me.prettyprint.cassandra.connection.client.HThriftClient;
import hector.me.prettyprint.cassandra.connection.security.KerberosHelper;
import hector.me.prettyprint.cassandra.service.CassandraHost;
import hector.me.prettyprint.hector.api.exceptions.HectorTransportException;
import java.net.Socket;
import java.net.SocketException;
import javax.security.auth.Subject;
import org.apache.cassandra.thrift.thriftlib.transport.TFramedTransport;
import org.apache.cassandra.thrift.thriftlib.transport.TSocket;
import org.apache.cassandra.thrift.thriftlib.transport.TTransportException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ietf.jgss.GSSContext;

public class HKerberosThriftClient
extends HThriftClient
implements HClient {
    private static Log log = LogFactory.getLog(HKerberosThriftClient.class);
    private Subject kerberosTicket;
    private String servicePrincipalName;

    public HKerberosThriftClient(Subject kerberosTicket, CassandraHost cassandraHost, String servicePrincipalName) {
        super(cassandraHost);
        this.kerberosTicket = kerberosTicket;
        this.servicePrincipalName = servicePrincipalName;
    }

    @Override
    public HKerberosThriftClient open() {
        if (this.isOpen()) {
            throw new IllegalStateException("Open called on already open connection. You should not have gotten here.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Creating a new thrift connection to %s", this.cassandraHost));
        }
        TSocket socket = new TSocket(this.cassandraHost.getHost(), this.cassandraHost.getPort(), this.timeout);
        if (this.cassandraHost.getUseSocketKeepalive()) {
            try {
                socket.getSocket().setKeepAlive(true);
            }
            catch (SocketException se) {
                throw new HectorTransportException("Could not set SO_KEEPALIVE on socket: ", se);
            }
        }
        this.transport = this.cassandraHost.getUseThriftFramedTransport() ? new TFramedTransport(socket) : socket;
        try {
            this.transport.open();
        }
        catch (TTransportException e) {
            log.debug((Object)("Unable to open transport to " + this.cassandraHost.getName()));
            throw new HectorTransportException("Unable to open transport to " + this.cassandraHost.getName() + " , " + e.getLocalizedMessage(), e);
        }
        Socket internalSocket = socket.getSocket();
        GSSContext clientContext = KerberosHelper.authenticateClient(internalSocket, this.kerberosTicket, this.servicePrincipalName);
        if (clientContext == null) {
            this.close();
            throw new HectorTransportException("Kerberos context couldn't be established with client.");
        }
        return this;
    }
}

