/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.connection.client;

import hector.me.prettyprint.cassandra.connection.client.HClient;
import hector.me.prettyprint.cassandra.service.CassandraHost;
import hector.me.prettyprint.cassandra.service.SystemProperties;
import hector.me.prettyprint.hector.api.exceptions.HInvalidRequestException;
import hector.me.prettyprint.hector.api.exceptions.HectorTransportException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.commons.lang.StringUtils;
import org.apache.cassandra.thrift.thriftlib.TException;
import org.apache.cassandra.thrift.thriftlib.protocol.TBinaryProtocol;
import org.apache.cassandra.thrift.thriftlib.transport.TFramedTransport;
import org.apache.cassandra.thrift.thriftlib.transport.TSocket;
import org.apache.cassandra.thrift.thriftlib.transport.TTransport;
import org.apache.cassandra.thrift.thriftlib.transport.TTransportException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HThriftClient
implements HClient,
Comparable {
    private static Log log = LogFactory.getLog(HThriftClient.class);
    private static final String NAME_FORMAT = "CassandraClient<%s-%d>";
    private static final AtomicLong serial = new AtomicLong(0L);
    final CassandraHost cassandraHost;
    private final long mySerial;
    protected final int timeout;
    protected String keyspaceName;
    private long useageStartTime;
    protected TTransport transport;
    protected Cassandra.Client cassandraClient;
    private final Map<String, String> credentials = new HashMap<String, String>();

    public HThriftClient(CassandraHost cassandraHost) {
        this.cassandraHost = cassandraHost;
        this.timeout = this.getTimeout(cassandraHost);
        this.mySerial = serial.incrementAndGet();
    }

    @Override
    public Cassandra.Client getCassandra() {
        if (!this.isOpen()) {
            throw new IllegalStateException("getCassandra called on client that was not open. You should not have gotten here.");
        }
        if (this.cassandraClient == null) {
            this.cassandraClient = new Cassandra.Client(new TBinaryProtocol(this.transport));
        }
        return this.cassandraClient;
    }

    @Override
    public Cassandra.Client getCassandra(String keyspaceNameArg) {
        this.getCassandra();
        if (keyspaceNameArg != null && !StringUtils.equals(this.keyspaceName, keyspaceNameArg)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("keyspace reseting from %s to %s", this.keyspaceName, keyspaceNameArg));
            }
            try {
                this.cassandraClient.set_keyspace(keyspaceNameArg);
            }
            catch (InvalidRequestException ire) {
                throw new HInvalidRequestException(ire);
            }
            catch (TException e) {
                throw new HectorTransportException(e);
            }
            this.keyspaceName = keyspaceNameArg;
        }
        return this.cassandraClient;
    }

    @Override
    public HThriftClient close() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Closing client %s", this));
        }
        if (this.isOpen()) {
            try {
                this.transport.flush();
            }
            catch (Exception e) {
                log.warn((Object)("Could not flush transport (to be expected if the pool is shutting down) in close for client: " + this.toString()), (Throwable)e);
            }
            finally {
                try {
                    this.transport.close();
                }
                catch (Exception e) {
                    log.warn((Object)("Exception on transport close for client: " + this.toString()), (Throwable)e);
                }
            }
        }
        return this;
    }

    @Override
    public HThriftClient open() {
        if (this.isOpen()) {
            throw new IllegalStateException("Open called on already open connection. You should not have gotten here.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Creating a new thrift connection to %s", this.cassandraHost));
        }
        TSocket socket = new TSocket(this.cassandraHost.getHost(), this.cassandraHost.getPort(), this.timeout);
        if (this.cassandraHost.getUseSocketKeepalive()) {
            try {
                socket.getSocket().setKeepAlive(true);
            }
            catch (SocketException se) {
                throw new HectorTransportException("Could not set SO_KEEPALIVE on socket: ", se);
            }
        }
        this.transport = this.cassandraHost.getUseThriftFramedTransport() ? new TFramedTransport(socket) : socket;
        try {
            this.transport.open();
        }
        catch (TTransportException e) {
            log.debug((Object)("Unable to open transport to " + this.cassandraHost.getName()));
            throw new HectorTransportException("Unable to open transport to " + this.cassandraHost.getName() + " , " + e.getLocalizedMessage(), e);
        }
        return this;
    }

    @Override
    public boolean isOpen() {
        boolean open = false;
        if (this.transport != null) {
            open = this.transport.isOpen();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Transport open status %s for client %s", open, this));
        }
        return open;
    }

    private int getTimeout(CassandraHost cassandraHost) {
        int timeoutVar = 0;
        if (cassandraHost != null && cassandraHost.getCassandraThriftSocketTimeout() > 0) {
            timeoutVar = cassandraHost.getCassandraThriftSocketTimeout();
        } else {
            String timeoutStr = System.getProperty(SystemProperties.CASSANDRA_THRIFT_SOCKET_TIMEOUT.toString());
            if (timeoutStr != null && timeoutStr.length() > 0) {
                try {
                    timeoutVar = Integer.parseInt(timeoutStr);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)"Invalid value for CASSANDRA_THRIFT_SOCKET_TIMEOUT", (Throwable)e);
                }
            }
        }
        return timeoutVar;
    }

    @Override
    public void startToUse() {
        this.useageStartTime = System.currentTimeMillis();
    }

    @Override
    public long getSinceLastUsed() {
        return System.currentTimeMillis() - this.useageStartTime;
    }

    public String toString() {
        return String.format(NAME_FORMAT, this.cassandraHost.getUrl(), this.mySerial);
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    @Override
    public CassandraHost getCassandraHost() {
        return this.cassandraHost;
    }

    @Override
    public boolean isAlreadyAuthenticated(Map<String, String> credentials) {
        return credentials != null && this.credentials.equals(credentials);
    }

    @Override
    public void clearAuthentication() {
        this.credentials.clear();
    }

    @Override
    public void setAuthenticated(Map<String, String> credentials) {
        this.clearAuthentication();
        this.credentials.putAll(credentials);
    }

    public int compareTo(Object o) {
        HThriftClient oComparedTo = (HThriftClient)o;
        return this.mySerial - oComparedTo.mySerial >= 0L ? 1 : -1;
    }

    public boolean isIdle() {
        return this.getSinceLastUsed() > 180000L;
    }
}

