/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.connection.factory;

import hector.me.prettyprint.cassandra.connection.client.HClient;
import hector.me.prettyprint.cassandra.connection.client.HKerberosThriftClient;
import hector.me.prettyprint.cassandra.connection.factory.HClientFactory;
import hector.me.prettyprint.cassandra.connection.security.KerberosHelper;
import hector.me.prettyprint.cassandra.service.CassandraHost;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HKerberosSecuredThriftClientFactoryImpl
implements HClientFactory {
    private static final Log log = LogFactory.getLog(HKerberosSecuredThriftClientFactoryImpl.class);
    public static final String JAAS_CONFIG = "jaas.conf";
    public static final String KRB5_CONFIG = "krb5.conf";
    private final Subject kerberosTicket;
    private String krbServicePrincipalName;

    public HKerberosSecuredThriftClientFactoryImpl() {
        String jaasConf = System.getProperty("java.security.auth.login.config");
        String krb5Conf = System.getProperty("java.security.krb5.conf");
        String krbDebug = System.getProperty("sun.security.krb5.debug");
        String krbClientReferenceName = System.getProperty("kerberos.client.reference.name");
        String krbClientUsername = System.getProperty("kerberos.client.principal.name");
        String krbClientPassword = System.getProperty("kerberos.client.password");
        this.krbServicePrincipalName = System.getProperty("kerberos.service.principal.name");
        if (krbDebug == null) {
            System.setProperty("sun.security.krb5.debug", "false");
        }
        if (jaasConf == null) {
            System.setProperty("java.security.auth.login.config", JAAS_CONFIG);
        }
        if (krb5Conf == null) {
            System.setProperty("java.security.krb5.conf", KRB5_CONFIG);
        }
        if (krbClientReferenceName == null) {
            krbClientReferenceName = "Client";
        }
        if (this.krbServicePrincipalName == null) {
            this.krbServicePrincipalName = "cassandra";
        }
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "true");
        log.info((Object)"Kerberos V5 was enabled for client<->server communications.");
        log.info((Object)"Properties:");
        log.info((Object)String.format("  sun.security.krb5.debug = %s", System.getProperty("sun.security.krb5.debug")));
        log.info((Object)String.format("  java.security.auth.login.config = %s", System.getProperty("java.security.auth.login.config")));
        log.info((Object)String.format("  java.security.krb5.conf = %s", System.getProperty("java.security.krb5.conf")));
        log.info((Object)String.format("  kerberos.client.reference.name = %s", System.getProperty("kerberos.client.reference.name", krbClientReferenceName)));
        log.info((Object)String.format("  kerberos.service.principal.name = %s", System.getProperty("kerberos.service.principal.name", this.krbServicePrincipalName)));
        log.info((Object)String.format("  kerberos.client.principal.name = %s", System.getProperty("kerberos.client.principal.name")));
        log.info((Object)String.format("  kerberos.client.password = %s", System.getProperty("kerberos.client.password")));
        log.info((Object)String.format("  javax.security.auth.useSubjectCredsOnly = true", new Object[0]));
        log.info((Object)"Trying to login to the KDC...");
        try {
            this.kerberosTicket = krbClientUsername != null && krbClientPassword != null ? KerberosHelper.loginService(krbClientReferenceName, krbClientUsername, krbClientPassword) : KerberosHelper.loginService(krbClientReferenceName);
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
        log.info((Object)"Kerberos authenticated successfully against KDC");
    }

    @Override
    public HClient createClient(CassandraHost ch) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creation of new client");
        }
        return new HKerberosThriftClient(this.kerberosTicket, ch, this.krbServicePrincipalName);
    }
}

