/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.connection.security;

import java.io.IOException;
import java.net.Socket;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public class KerberosHelper {
    private static Log log = LogFactory.getLog(KerberosHelper.class);

    public static Subject loginService(String serviceName) throws LoginException {
        LoginContext loginCtx = new LoginContext(serviceName, new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            }
        });
        loginCtx.login();
        return loginCtx.getSubject();
    }

    public static Subject loginService(String serviceName, String username, String password) throws LoginException {
        LoginContext loginCtx = new LoginContext(serviceName, new LoginCallbackHandler(username, password));
        loginCtx.login();
        return loginCtx.getSubject();
    }

    public static GSSContext authenticateClient(final Socket socket, Subject subject, final String servicePrincipalName) {
        return Subject.doAs(subject, new PrivilegedAction<GSSContext>(){

            @Override
            public GSSContext run() {
                try {
                    GSSManager manager = GSSManager.getInstance();
                    GSSName peerName = manager.createName(servicePrincipalName, GSSName.NT_HOSTBASED_SERVICE);
                    GSSContext context = manager.createContext(peerName, null, null, 0);
                    while (!context.isEstablished()) {
                        context.initSecContext(socket.getInputStream(), socket.getOutputStream());
                    }
                    return context;
                }
                catch (Exception e) {
                    log.warn((Object)"Unable to authenticate client against Kerberos", (Throwable)e);
                    return null;
                }
            }
        });
    }

    public static String getSourcePrinciple(GSSContext context) {
        try {
            return context.getSrcName().toString();
        }
        catch (GSSException e) {
            throw new RuntimeException(e);
        }
    }

    static class LoginCallbackHandler
    implements CallbackHandler {
        private String password;
        private String username;

        public LoginCallbackHandler() {
        }

        public LoginCallbackHandler(String name, String password) {
            this.username = name;
            this.password = password;
        }

        public LoginCallbackHandler(String password) {
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback && this.username != null) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    nc.setName(this.username);
                    continue;
                }
                if (!(callbacks[i] instanceof PasswordCallback)) continue;
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                pc.setPassword(this.password.toCharArray());
            }
        }
    }
}

