/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.examples;

import hector.me.prettyprint.cassandra.serializers.StringSerializer;
import hector.me.prettyprint.hector.api.Cluster;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.HColumn;
import hector.me.prettyprint.hector.api.beans.Rows;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.factory.HFactory;
import hector.me.prettyprint.hector.api.mutation.Mutator;
import hector.me.prettyprint.hector.api.query.ColumnQuery;
import hector.me.prettyprint.hector.api.query.MultigetSliceQuery;
import hector.me.prettyprint.hector.api.query.QueryResult;
import java.util.HashMap;
import java.util.Map;

public class ExampleDaoV2 {
    private static final String KEYSPACE = "Keyspace1";
    private static final String HOST_PORT = "localhost:9170";
    private static final String CF_NAME = "Standard1";
    private static final String COLUMN_NAME = "v";
    private final StringSerializer serializer = StringSerializer.get();
    private final Keyspace keyspace;

    public static void main(String[] args) throws HectorException {
        Cluster c = HFactory.getOrCreateCluster("MyCluster", HOST_PORT);
        ExampleDaoV2 ed = new ExampleDaoV2(HFactory.createKeyspace(KEYSPACE, c));
        ed.insert("key1", "value1", StringSerializer.get());
        System.out.println(ed.get("key1", StringSerializer.get()));
    }

    public ExampleDaoV2(Keyspace keyspace) {
        this.keyspace = keyspace;
    }

    public <K> void insert(K key, String value, Serializer<K> keySerializer) {
        HFactory.createMutator(this.keyspace, keySerializer).insert(key, CF_NAME, HFactory.createColumn(COLUMN_NAME, value, this.serializer, this.serializer));
    }

    public <K> String get(K key, Serializer<K> keySerializer) throws HectorException {
        ColumnQuery<K, String, String> q = HFactory.createColumnQuery(this.keyspace, keySerializer, this.serializer, this.serializer);
        QueryResult r = q.setKey(key).setName(COLUMN_NAME).setColumnFamily(CF_NAME).execute();
        HColumn c = (HColumn)r.get();
        return c == null ? null : (String)c.getValue();
    }

    public <K> Map<K, String> getMulti(Serializer<K> keySerializer, K ... keys) {
        MultigetSliceQuery<K, String, String> q = HFactory.createMultigetSliceQuery(this.keyspace, keySerializer, this.serializer, this.serializer);
        q.setColumnFamily(CF_NAME);
        q.setKeys(keys);
        q.setColumnNames((String[])new String[]{COLUMN_NAME});
        QueryResult r = q.execute();
        Rows rows = (Rows)r.get();
        HashMap ret = new HashMap(keys.length);
        for (K k : keys) {
            HColumn c = rows.getByKey(k).getColumnSlice().getColumnByName(COLUMN_NAME);
            if (c == null || c.getValue() == null) continue;
            ret.put(k, c.getValue());
        }
        return ret;
    }

    public <K> void insertMulti(Map<K, String> keyValues, Serializer<K> keySerializer) {
        Mutator<K> m = HFactory.createMutator(this.keyspace, keySerializer);
        for (Map.Entry<K, String> keyValue : keyValues.entrySet()) {
            m.addInsertion(keyValue.getKey(), CF_NAME, HFactory.createColumn(COLUMN_NAME, keyValue.getValue(), this.keyspace.createClock(), this.serializer, this.serializer));
        }
        m.execute();
    }

    public <K> void delete(Serializer<K> keySerializer, K ... keys) {
        Mutator<K> m = HFactory.createMutator(this.keyspace, keySerializer);
        for (K key : keys) {
            m.addDeletion(key, CF_NAME, COLUMN_NAME, this.serializer);
        }
        m.execute();
    }
}

