/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.io;

import hector.me.prettyprint.cassandra.serializers.BytesArraySerializer;
import hector.me.prettyprint.cassandra.serializers.LongSerializer;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.HColumn;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.factory.HFactory;
import hector.me.prettyprint.hector.api.query.ColumnQuery;
import hector.me.prettyprint.hector.api.query.QueryResult;
import java.io.IOException;
import java.io.InputStream;

public class ChunkInputStream<T>
extends InputStream {
    private T key;
    private byte[] chunk;
    private Keyspace keyspace;
    private String cf;
    private long chunkPos = 0L;
    private int pos;
    private Serializer<T> rowKeySerializer;

    public ChunkInputStream(Keyspace keyspace, String cf, T key, Serializer<T> rowKeySerializer) {
        this.key = key;
        this.keyspace = keyspace;
        this.cf = cf;
        this.rowKeySerializer = rowKeySerializer;
    }

    @Override
    public int read() throws IOException {
        if (!(this.chunk != null && this.pos + 1 != this.chunk.length || this.fetchChunk())) {
            return -1;
        }
        return this.chunk[this.pos++] & 0xFF;
    }

    private boolean fetchChunk() throws IOException {
        try {
            ColumnQuery<T, Long, byte[]> query = HFactory.createColumnQuery(this.keyspace, this.rowKeySerializer, LongSerializer.get(), BytesArraySerializer.get());
            QueryResult result = query.setColumnFamily(this.cf).setKey(this.key).setName(this.chunkPos).execute();
            HColumn column = (HColumn)result.get();
            if (column != null) {
                this.chunk = (byte[])column.getValue();
                ++this.chunkPos;
                this.pos = 0;
                return true;
            }
            return false;
        }
        catch (HectorException e) {
            throw new IOException("Unable to read data", e);
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

