/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model;

import hector.me.prettyprint.cassandra.model.HColumnImpl;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.ColumnSlice;
import hector.me.prettyprint.hector.api.beans.HColumn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Column;

public final class ColumnSliceImpl<N, V>
implements ColumnSlice<N, V> {
    private Map<N, HColumn<N, V>> columnsMap;
    private final List<HColumn<N, V>> columnsList;

    public ColumnSliceImpl(List<Column> tColumns, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        Assert.noneNull(tColumns, nameSerializer, valueSerializer);
        ArrayList<HColumn<N, V>> list = new ArrayList<HColumn<N, V>>(tColumns.size());
        for (Column c : tColumns) {
            HColumnImpl<N, V> column = new HColumnImpl<N, V>(c, nameSerializer, valueSerializer);
            list.add(column);
        }
        this.columnsList = list;
    }

    @Override
    public List<HColumn<N, V>> getColumns() {
        return this.columnsList;
    }

    @Override
    public HColumn<N, V> getColumnByName(N columnName) {
        if (null == this.columnsMap) {
            this.columnsMap = new HashMap<N, HColumn<N, V>>(this.columnsList.size());
            for (HColumn<N, V> column : this.columnsList) {
                this.columnsMap.put(column.getName(), column);
            }
        }
        return this.columnsMap.get(columnName);
    }

    public String toString() {
        return String.format("ColumnSlice(%s)", this.columnsList.toString());
    }
}

