/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model;

import hector.me.prettyprint.cassandra.model.CounterSliceImpl;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.CounterRow;
import hector.me.prettyprint.hector.api.beans.CounterSlice;
import java.util.List;
import org.apache.cassandra.thrift.CounterColumn;

public final class CounterRowImpl<K, N>
implements CounterRow<K, N> {
    private final K rowKey;
    private final CounterSlice<N> columnSlice;

    CounterRowImpl(K k, List<CounterColumn> columns, Serializer<N> nameSerializer) {
        Assert.noneNull(k, columns, nameSerializer);
        this.rowKey = k;
        this.columnSlice = new CounterSliceImpl<N>(columns, nameSerializer);
    }

    @Override
    public K getKey() {
        return this.rowKey;
    }

    @Override
    public CounterSlice<N> getColumnSlice() {
        return this.columnSlice;
    }

    public String toString() {
        return "Row(" + this.rowKey + "," + this.columnSlice + ")";
    }
}

