/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model;

import hector.me.prettyprint.cassandra.model.CounterSuperRowImpl;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.CounterSuperRow;
import hector.me.prettyprint.hector.api.beans.CounterSuperRows;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.CounterSuperColumn;

public class CounterSuperRowsImpl<K, SN, N>
implements CounterSuperRows<K, SN, N> {
    protected final Map<K, CounterSuperRow<K, SN, N>> rows;
    Serializer<K> keySerializer;

    public CounterSuperRowsImpl(Map<K, List<CounterSuperColumn>> thriftRet, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer) {
        Assert.noneNull(thriftRet, keySerializer, sNameSerializer, nameSerializer);
        this.keySerializer = keySerializer;
        this.rows = new LinkedHashMap<K, CounterSuperRow<K, SN, N>>(thriftRet.size());
        for (Map.Entry<K, List<CounterSuperColumn>> entry : thriftRet.entrySet()) {
            this.rows.put(entry.getKey(), new CounterSuperRowImpl<K, SN, N>(entry.getKey(), entry.getValue(), sNameSerializer, nameSerializer));
        }
    }

    @Override
    public CounterSuperRow<K, SN, N> getByKey(K key) {
        return this.rows.get(key);
    }

    @Override
    public int getCount() {
        return this.rows.size();
    }

    @Override
    public Iterator<CounterSuperRow<K, SN, N>> iterator() {
        return this.rows.values().iterator();
    }

    public String toString() {
        return "SuperRows(" + this.rows + ")";
    }
}

