/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model;

import hector.me.prettyprint.cassandra.model.AbstractBasicQuery;
import hector.me.prettyprint.cassandra.model.CqlRows;
import hector.me.prettyprint.cassandra.model.QueryResultImpl;
import hector.me.prettyprint.cassandra.serializers.StringSerializer;
import hector.me.prettyprint.cassandra.service.Operation;
import hector.me.prettyprint.cassandra.service.OperationType;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.query.QueryResult;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CqlQuery<K, N, V>
extends AbstractBasicQuery<K, N, CqlRows<K, N, V>> {
    private static Log log = LogFactory.getLog(CqlQuery.class);
    private Serializer<V> valueSerializer;
    private ByteBuffer query;
    private boolean useCompression;
    private boolean suppressKeyInColumns;
    private static ByteBuffer KEY_BB = StringSerializer.get().toByteBuffer("KEY");

    public CqlQuery(Keyspace k, Serializer<K> keySerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        super(k, keySerializer, nameSerializer);
        this.valueSerializer = valueSerializer;
    }

    public CqlQuery<K, N, V> setQuery(String query) {
        this.query = StringSerializer.get().toByteBuffer(query);
        return this;
    }

    public CqlQuery<K, N, V> setQuery(ByteBuffer qeury) {
        this.query = qeury;
        return this;
    }

    public CqlQuery<K, N, V> setSuppressKeyInColumns(boolean suppressKeyInColumns) {
        this.suppressKeyInColumns = suppressKeyInColumns;
        return this;
    }

    public CqlQuery<K, N, V> useCompression() {
        this.useCompression = true;
        return this;
    }

    @Override
    public QueryResult<CqlRows<K, N, V>> execute() {
        return new QueryResultImpl<CqlRows<K, N, V>>(this.keyspace.doExecuteOperation(new Operation<CqlRows<K, N, V>>(OperationType.READ){

            @Override
            public CqlRows<K, N, V> execute(Cassandra.Client cassandra) throws HectorException {
                CqlRows rows = null;
                try {
                    CqlResult result = cassandra.execute_cql_query(CqlQuery.this.query, CqlQuery.this.useCompression ? Compression.GZIP : Compression.NONE);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Found CqlResult: %s", result));
                    }
                    switch (result.getType()) {
                        case VOID: {
                            rows = new CqlRows();
                            break;
                        }
                        default: {
                            if (result.getRowsSize() > 0) {
                                LinkedHashMap<ByteBuffer, List> ret = new LinkedHashMap<ByteBuffer, List>(result.getRowsSize());
                                Iterator<CqlRow> rowsIter = result.getRowsIterator();
                                while (rowsIter.hasNext()) {
                                    CqlRow row = rowsIter.next();
                                    ret.put(ByteBuffer.wrap(row.getKey()), CqlQuery.this.filterKeyColumn(row));
                                }
                                Map thriftRet = CqlQuery.this.keySerializer.fromBytesMap(ret);
                                rows = new CqlRows((LinkedHashMap)thriftRet, CqlQuery.this.columnNameSerializer, CqlQuery.this.valueSerializer);
                            }
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    throw CqlQuery.this.keyspace.getExceptionsTranslator().translate(ex);
                }
                return rows;
            }
        }), this);
    }

    private List<Column> filterKeyColumn(CqlRow row) {
        if (this.suppressKeyInColumns && row.isSetColumns() && row.columns.size() > 0) {
            Iterator<Column> columnsIterator = row.getColumnsIterator();
            Column column = columnsIterator.next();
            if (column.name.duplicate().equals(KEY_BB)) {
                columnsIterator.remove();
            }
        }
        return row.getColumns();
    }
}

