/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model;

import hector.me.prettyprint.cassandra.connection.HConnectionManager;
import hector.me.prettyprint.cassandra.model.ExecutionResult;
import hector.me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import hector.me.prettyprint.cassandra.service.ExceptionsTranslator;
import hector.me.prettyprint.cassandra.service.ExceptionsTranslatorImpl;
import hector.me.prettyprint.cassandra.service.FailoverPolicy;
import hector.me.prettyprint.cassandra.service.KeyspaceServiceImpl;
import hector.me.prettyprint.cassandra.service.Operation;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.ConsistencyLevelPolicy;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import java.util.Collections;
import java.util.Map;

public class ExecutingKeyspace
implements Keyspace {
    private static final Map<String, String> EMPTY_CREDENTIALS = Collections.emptyMap();
    protected ConsistencyLevelPolicy consistencyLevelPolicy;
    protected FailoverPolicy failoverPolicy;
    protected final HConnectionManager connectionManager;
    protected final String keyspace;
    protected final Map<String, String> credentials;
    private final ExceptionsTranslator exceptionTranslator;

    public ExecutingKeyspace(String keyspace, HConnectionManager connectionManager, ConsistencyLevelPolicy consistencyLevelPolicy, FailoverPolicy failoverPolicy) {
        this(keyspace, connectionManager, consistencyLevelPolicy, failoverPolicy, EMPTY_CREDENTIALS);
    }

    public ExecutingKeyspace(String keyspace, HConnectionManager connectionManager, ConsistencyLevelPolicy consistencyLevelPolicy, FailoverPolicy failoverPolicy, Map<String, String> credentials) {
        Assert.noneNull(consistencyLevelPolicy, connectionManager);
        this.keyspace = keyspace;
        this.connectionManager = connectionManager;
        this.consistencyLevelPolicy = consistencyLevelPolicy;
        this.failoverPolicy = failoverPolicy;
        this.credentials = credentials;
        this.exceptionTranslator = new ExceptionsTranslatorImpl();
    }

    @Override
    public void setConsistencyLevelPolicy(ConsistencyLevelPolicy cp) {
        this.consistencyLevelPolicy = cp;
    }

    @Override
    public String getKeyspaceName() {
        return this.keyspace;
    }

    public String toString() {
        return "ExecutingKeyspace(" + this.keyspace + "," + this.connectionManager + ")";
    }

    @Override
    public long createClock() {
        return this.connectionManager.createClock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ExecutionResult<T> doExecute(KeyspaceOperationCallback<T> koc) throws HectorException {
        KeyspaceServiceImpl ks = null;
        try {
            ks = new KeyspaceServiceImpl(this.keyspace, this.consistencyLevelPolicy, this.connectionManager, this.failoverPolicy, this.credentials);
            ExecutionResult<T> executionResult = koc.doInKeyspaceAndMeasure(ks);
            return executionResult;
        }
        finally {
            if (ks != null) {
                // empty if block
            }
        }
    }

    public <T> ExecutionResult<T> doExecuteOperation(Operation<T> operation) throws HectorException {
        operation.applyConnectionParams(this.keyspace, this.consistencyLevelPolicy, this.failoverPolicy, this.credentials);
        this.connectionManager.operateWithFailover(operation);
        return operation.getExecutionResult();
    }

    public ExceptionsTranslator getExceptionsTranslator() {
        return this.exceptionTranslator;
    }
}

