/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model;

import hector.me.prettyprint.cassandra.serializers.SerializerTypeInferer;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.HColumn;
import java.nio.ByteBuffer;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.commons.lang.builder.EqualsBuilder;
import org.apache.cassandra.thrift.commons.lang.builder.HashCodeBuilder;

public final class HColumnImpl<N, V>
implements HColumn<N, V> {
    private Column column;
    private Serializer<N> nameSerializer;
    private Serializer<V> valueSerializer;
    private N cachedName;
    private V cachedValue;

    public HColumnImpl(N name, V value, long clock, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        this(nameSerializer, valueSerializer);
        Assert.notNull(name, "name is null");
        Assert.notNull(value, "value is null");
        this.column = new Column(nameSerializer.toByteBuffer(name));
        this.column.setValue(valueSerializer.toByteBuffer(value));
        this.column.setTimestamp(clock);
    }

    public HColumnImpl(N name, V value, long clock, int ttl, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        this(name, value, clock, nameSerializer, valueSerializer);
        this.setTtl(ttl);
    }

    public HColumnImpl(Column thriftColumn, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        this(nameSerializer, valueSerializer);
        Assert.notNull(thriftColumn, "thriftColumn is null");
        this.column = thriftColumn;
    }

    public HColumnImpl(Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        Assert.notNull(nameSerializer, "nameSerializer is null");
        Assert.notNull(valueSerializer, "valueSerializer is null");
        this.nameSerializer = nameSerializer;
        this.valueSerializer = valueSerializer;
        this.column = new Column();
    }

    public HColumnImpl(N name, V value, long clock) {
        this(name, value, clock, SerializerTypeInferer.getSerializer(name), SerializerTypeInferer.getSerializer(value));
    }

    @Override
    public HColumn<N, V> setName(N name) {
        Assert.notNull(name, "name is null");
        this.column.setName(this.nameSerializer.toByteBuffer(name));
        this.cachedName = null;
        return this;
    }

    @Override
    public HColumn<N, V> setValue(V value) {
        Assert.notNull(value, "value is null");
        this.column.setValue(this.valueSerializer.toByteBuffer(value));
        this.cachedValue = null;
        return this;
    }

    @Override
    public HColumn<N, V> setClock(long clock) {
        this.column.setTimestamp(clock);
        return this;
    }

    @Override
    public HColumn<N, V> setTtl(int ttl) {
        this.column.setTtl(ttl);
        return this;
    }

    @Override
    public int getTtl() {
        return this.column.ttl;
    }

    @Override
    public N getName() {
        if (this.column.isSetName()) {
            if (null == this.cachedName) {
                this.cachedName = this.nameSerializer.fromByteBuffer(this.column.name.duplicate());
            }
            return this.cachedName;
        }
        return null;
    }

    @Override
    public V getValue() {
        if (this.column.isSetValue()) {
            if (null == this.cachedValue) {
                this.cachedValue = this.valueSerializer.fromByteBuffer(this.column.value.duplicate());
            }
            return this.cachedValue;
        }
        return null;
    }

    @Override
    public long getClock() {
        return this.column.timestamp;
    }

    public Column toThrift() {
        return this.column;
    }

    public HColumn<N, V> fromThrift(Column c) {
        Assert.notNull(c, "column is null");
        this.column = c;
        return this;
    }

    @Override
    public Serializer<N> getNameSerializer() {
        return this.nameSerializer;
    }

    @Override
    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public ByteBuffer getNameBytes() {
        return this.column.isSetName() ? this.column.name.duplicate() : null;
    }

    @Override
    public ByteBuffer getValueBytes() {
        return this.column.isSetValue() ? this.column.value.duplicate() : null;
    }

    @Override
    public HColumn<N, V> clear() {
        this.column.value = null;
        this.column.timestamp = 0L;
        this.column.ttl = 0;
        this.column.setTimestampIsSet(false);
        this.column.setTtlIsSet(false);
        this.column.setValueIsSet(false);
        return this;
    }

    @Override
    public HColumn<N, V> apply(V value, long clock, int ttl) {
        this.setValue(value);
        this.column.setTimestamp(clock);
        this.column.setTtl(ttl);
        return this;
    }

    public HColumn<N, V> apply(Column c) {
        this.column = c;
        this.cachedName = null;
        this.cachedValue = null;
        return this;
    }

    public String toString() {
        return String.format("HColumn(%s=%s)", this.getName(), this.getValue());
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getName()).append(this.getValue()).append(this.getClock()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        HColumnImpl other = (HColumnImpl)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.getName(), other.getName()).append(this.getValue(), other.getValue()).append(this.getClock(), other.getClock()).isEquals();
    }
}

