/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model;

import hector.me.prettyprint.cassandra.model.HCounterColumnImpl;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.HCounterColumn;
import hector.me.prettyprint.hector.api.beans.HCounterSuperColumn;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CounterSuperColumn;

public final class HCounterSuperColumnImpl<SN, N>
implements HCounterSuperColumn<SN, N> {
    private SN superName;
    private List<HCounterColumn<N>> counterColumns;
    private final Serializer<SN> superNameSerializer;
    private final Serializer<N> nameSerializer;

    public HCounterSuperColumnImpl(SN sName, List<HCounterColumn<N>> counterColumns, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer) {
        this(sNameSerializer, nameSerializer);
        Assert.notNull(sName, "Name is null");
        Assert.notNull(counterColumns, "Columns are null");
        this.superName = sName;
        this.counterColumns = counterColumns;
    }

    public HCounterSuperColumnImpl(CounterSuperColumn thriftCounterSuperColumn, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer) {
        this(sNameSerializer, nameSerializer);
        Assert.noneNull(thriftCounterSuperColumn, sNameSerializer, nameSerializer);
        this.superName = sNameSerializer.fromByteBuffer(ByteBuffer.wrap(thriftCounterSuperColumn.getName()));
        this.counterColumns = super.fromThriftColumns(thriftCounterSuperColumn.getColumns());
    }

    public HCounterSuperColumnImpl(Serializer<SN> sNameSerializer, Serializer<N> nameSerializer) {
        Assert.noneNull(sNameSerializer, nameSerializer);
        this.superNameSerializer = sNameSerializer;
        this.nameSerializer = nameSerializer;
    }

    @Override
    public HCounterSuperColumn<SN, N> addSubCounterColumn(HCounterColumn<N> counterColumn) {
        if (this.counterColumns == null) {
            this.counterColumns = new ArrayList<HCounterColumn<N>>();
        }
        this.counterColumns.add(counterColumn);
        return this;
    }

    @Override
    public HCounterSuperColumn<SN, N> setName(SN name) {
        Assert.notNull(name, "name is null");
        this.superName = name;
        return this;
    }

    @Override
    public HCounterSuperColumn<SN, N> setSubcolumns(List<HCounterColumn<N>> counterSubcolumns) {
        Assert.notNull(counterSubcolumns, "subcolumns are null");
        this.counterColumns = counterSubcolumns;
        return this;
    }

    @Override
    public int getSize() {
        return this.counterColumns == null ? 0 : this.counterColumns.size();
    }

    @Override
    public SN getName() {
        return this.superName;
    }

    @Override
    public List<HCounterColumn<N>> getColumns() {
        return this.counterColumns;
    }

    @Override
    public HCounterColumn<N> get(int i) {
        return this.counterColumns.get(i);
    }

    @Override
    public Serializer<SN> getNameSerializer() {
        return this.superNameSerializer;
    }

    @Override
    public byte[] getNameBytes() {
        return this.superNameSerializer.toByteBuffer(this.getName()).array();
    }

    @Override
    public ByteBuffer getNameByteBuffer() {
        return this.superNameSerializer.toByteBuffer(this.getName());
    }

    public CounterSuperColumn toThrift() {
        if (this.superName == null || this.counterColumns == null) {
            return null;
        }
        return new CounterSuperColumn(this.superNameSerializer.toByteBuffer(this.superName), this.toThriftColumn());
    }

    private List<CounterColumn> toThriftColumn() {
        ArrayList<CounterColumn> ret = new ArrayList<CounterColumn>(this.counterColumns.size());
        for (HCounterColumn<N> c : this.counterColumns) {
            ret.add(((HCounterColumnImpl)c).toThrift());
        }
        return ret;
    }

    private List<HCounterColumn<N>> fromThriftColumns(List<CounterColumn> tcolumns) {
        ArrayList<HCounterColumn<N>> cs = new ArrayList<HCounterColumn<N>>(tcolumns.size());
        for (CounterColumn c : tcolumns) {
            cs.add(new HCounterColumnImpl<N>(c, this.nameSerializer));
        }
        return cs;
    }

    @Override
    public Serializer<SN> getSuperNameSerializer() {
        return this.superNameSerializer;
    }

    public String toString() {
        return String.format("HCounterSuperColumn(%s,%s)", this.superName, this.counterColumns);
    }
}

