/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model;

import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;

public final class HSlicePredicate<N> {
    protected Collection<N> columnNames;
    protected N start;
    protected N finish;
    protected boolean reversed;
    protected int count;
    private boolean countSet = false;
    protected final Serializer<N> columnNameSerializer;
    protected PredicateType predicateType = PredicateType.Unknown;
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(new byte[0]);

    public HSlicePredicate(Serializer<N> columnNameSerializer) {
        Assert.notNull(columnNameSerializer, "columnNameSerializer can't be null");
        this.columnNameSerializer = columnNameSerializer;
    }

    public HSlicePredicate<N> setColumnNames(N ... columnNames) {
        return this.setColumnNames((Collection<N>)Arrays.asList(columnNames));
    }

    public HSlicePredicate<N> addColumnName(N columnName) {
        if (this.columnNames == null) {
            this.columnNames = new ArrayList<N>();
        }
        this.columnNames.add(columnName);
        this.predicateType = PredicateType.ColumnNames;
        return this;
    }

    public HSlicePredicate<N> setColumnNames(Collection<N> columnNames) {
        this.columnNames = columnNames;
        this.predicateType = PredicateType.ColumnNames;
        return this;
    }

    public HSlicePredicate<N> setKeysOnlyPredicate() {
        this.columnNames = new ArrayList<N>();
        this.predicateType = PredicateType.ColumnNames;
        return this;
    }

    public HSlicePredicate<N> setStartOn(N start) {
        this.start = start;
        this.predicateType = PredicateType.Range;
        return this;
    }

    public HSlicePredicate<N> setEndOn(N finish) {
        this.finish = finish;
        this.predicateType = PredicateType.Range;
        return this;
    }

    public HSlicePredicate<N> setCount(int count) {
        this.count = count;
        this.countSet = true;
        this.predicateType = PredicateType.Range;
        return this;
    }

    public HSlicePredicate<N> setReversed(boolean reversed) {
        this.reversed = reversed;
        this.predicateType = PredicateType.Range;
        return this;
    }

    public HSlicePredicate<N> setRange(N start, N finish, boolean reversed, int count) {
        this.start = start;
        this.finish = finish;
        this.reversed = reversed;
        this.count = count;
        this.countSet = true;
        this.predicateType = PredicateType.Range;
        return this;
    }

    public Collection<N> getColumnNames() {
        return Collections.unmodifiableCollection(this.columnNames);
    }

    public SlicePredicate toThrift() {
        SlicePredicate pred = new SlicePredicate();
        switch (this.predicateType) {
            case ColumnNames: {
                if (this.columnNames == null) {
                    return null;
                }
                pred.setColumn_names(this.toThriftColumnNames(this.columnNames));
                break;
            }
            case Range: {
                Assert.isTrue(this.countSet, "Count was not set, neither were column-names set, can't execute");
                SliceRange range = new SliceRange(this.findBytes(this.start), this.findBytes(this.finish), this.reversed, this.count);
                pred.setSlice_range(range);
                break;
            }
            default: {
                throw new HectorException("Neither column names nor range were set, this is an invalid slice predicate");
            }
        }
        return pred;
    }

    private ByteBuffer findBytes(N val) {
        ByteBuffer valBytes = val == null ? EMPTY_BYTE_BUFFER : this.columnNameSerializer.toByteBuffer(val);
        return valBytes;
    }

    private List<ByteBuffer> toThriftColumnNames(Collection<N> clms) {
        ArrayList<ByteBuffer> ret = new ArrayList<ByteBuffer>(clms.size());
        for (N name : clms) {
            ret.add(this.columnNameSerializer.toByteBuffer(name));
        }
        return ret;
    }

    public String toString() {
        return String.format("HSlicePredicate(%s)", this.predicateType == PredicateType.ColumnNames ? this.columnNames : this.formatPredicate());
    }

    private String formatPredicate() {
        return String.format("start:[%s],end:[%s],count:%d,reversed:%b", this.start != null ? this.start.toString() : "''", this.finish != null ? this.finish.toString() : "''", this.count, this.reversed);
    }

    protected static enum PredicateType {
        Unknown,
        ColumnNames,
        Range;

    }
}

