/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model;

import hector.me.prettyprint.cassandra.model.ExecutingKeyspace;
import hector.me.prettyprint.cassandra.model.HSlicePredicate;
import hector.me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import hector.me.prettyprint.cassandra.model.QueryResultImpl;
import hector.me.prettyprint.cassandra.service.KeyspaceService;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.query.Query;
import hector.me.prettyprint.hector.api.query.QueryResult;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.ColumnParent;

public class MultigetCountQuery<K, N>
implements Query<Map<K, Integer>> {
    protected final ExecutingKeyspace keyspace;
    protected final Serializer<K> keySerializer;
    protected String columnFamily;
    protected List<K> keys;
    protected final HSlicePredicate<N> slicePredicate;

    public MultigetCountQuery(Keyspace k, Serializer<K> keySerializer, Serializer<N> nameSerializer) {
        Assert.notNull(k, "keyspace can't be null");
        Assert.notNull(keySerializer, "keySerializer can't be null");
        Assert.notNull(nameSerializer, "columnNameSerializer is null");
        this.keyspace = (ExecutingKeyspace)k;
        this.keySerializer = keySerializer;
        this.slicePredicate = new HSlicePredicate<N>(nameSerializer);
    }

    public MultigetCountQuery<K, N> setKeys(K ... keys) {
        this.keys = Arrays.asList(keys);
        return this;
    }

    public MultigetCountQuery<K, N> setColumnFamily(String cf) {
        this.columnFamily = cf;
        return this;
    }

    public MultigetCountQuery<K, N> setColumnNames(N ... columnNames) {
        this.slicePredicate.setColumnNames(columnNames);
        return this;
    }

    public MultigetCountQuery<K, N> setRange(N start, N finish, int count) {
        this.slicePredicate.setRange(start, finish, false, count);
        return this;
    }

    @Override
    public QueryResult<Map<K, Integer>> execute() {
        Assert.notNull(this.keys, "keys list is null");
        Assert.notNull(this.columnFamily, "columnFamily is null");
        return new QueryResultImpl<Map<K, Integer>>(this.keyspace.doExecute(new KeyspaceOperationCallback<Map<K, Integer>>(){

            @Override
            public Map<K, Integer> doInKeyspace(KeyspaceService ks) throws HectorException {
                ColumnParent columnParent = new ColumnParent(MultigetCountQuery.this.columnFamily);
                Map counts = MultigetCountQuery.this.keySerializer.fromBytesMap(ks.multigetCount(MultigetCountQuery.this.keySerializer.toBytesList(MultigetCountQuery.this.keys), columnParent, MultigetCountQuery.this.slicePredicate.toThrift()));
                return counts;
            }
        }), this);
    }

    public String toString() {
        return String.format("MultigetCountQuery(%s) on cf: %s with keys: %s", this.slicePredicate.toString(), this.columnFamily, this.keys.toString());
    }
}

