/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model;

import hector.me.prettyprint.cassandra.model.ExecutingKeyspace;
import hector.me.prettyprint.cassandra.model.HColumnImpl;
import hector.me.prettyprint.cassandra.model.HCounterColumnImpl;
import hector.me.prettyprint.cassandra.model.HCounterSuperColumnImpl;
import hector.me.prettyprint.cassandra.model.HSuperColumnImpl;
import hector.me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import hector.me.prettyprint.cassandra.model.MutationResultImpl;
import hector.me.prettyprint.cassandra.model.thrift.ThriftConverter;
import hector.me.prettyprint.cassandra.model.thrift.ThriftFactory;
import hector.me.prettyprint.cassandra.serializers.TypeInferringSerializer;
import hector.me.prettyprint.cassandra.service.BatchMutation;
import hector.me.prettyprint.cassandra.service.BatchSizeHint;
import hector.me.prettyprint.cassandra.service.KeyspaceService;
import hector.me.prettyprint.cassandra.service.Operation;
import hector.me.prettyprint.cassandra.service.OperationType;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.HColumn;
import hector.me.prettyprint.hector.api.beans.HCounterColumn;
import hector.me.prettyprint.hector.api.beans.HCounterSuperColumn;
import hector.me.prettyprint.hector.api.beans.HSuperColumn;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.mutation.MutationResult;
import hector.me.prettyprint.hector.api.mutation.Mutator;
import java.util.Arrays;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.SlicePredicate;

public final class MutatorImpl<K>
implements Mutator<K> {
    private final ExecutingKeyspace keyspace;
    protected final Serializer<K> keySerializer;
    private BatchMutation<K> pendingMutations;
    private BatchSizeHint sizeHint;

    public MutatorImpl(Keyspace keyspace, Serializer<K> keySerializer, BatchSizeHint sizeHint) {
        this.keyspace = (ExecutingKeyspace)keyspace;
        this.keySerializer = keySerializer;
        this.sizeHint = sizeHint;
    }

    public MutatorImpl(Keyspace keyspace, Serializer<K> keySerializer) {
        this(keyspace, keySerializer, null);
    }

    public MutatorImpl(Keyspace keyspace) {
        this(keyspace, TypeInferringSerializer.get());
    }

    public MutatorImpl(Keyspace keyspace, BatchSizeHint sizeHint) {
        this(keyspace, TypeInferringSerializer.get(), sizeHint);
    }

    @Override
    public <N, V> MutationResult insert(K key, String cf, HColumn<N, V> c) {
        this.addInsertion(key, cf, c);
        return this.execute();
    }

    @Override
    public <SN, N, V> MutationResult insert(K key, String cf, HSuperColumn<SN, N, V> superColumn) {
        this.addInsertion(key, cf, superColumn);
        return this.execute();
    }

    @Override
    public <N> MutationResult delete(K key, String cf, N columnName, Serializer<N> nameSerializer) {
        this.addDeletion(key, cf, columnName, nameSerializer);
        return this.execute();
    }

    @Override
    public <N> MutationResult delete(K key, String cf, N columnName, Serializer<N> nameSerializer, long clock) {
        this.addDeletion(key, cf, columnName, nameSerializer, clock);
        return this.execute();
    }

    @Override
    public <SN, N> MutationResult subDelete(final K key, final String cf, final SN supercolumnName, final N columnName, final Serializer<SN> sNameSerializer, final Serializer<N> nameSerializer) {
        return new MutationResultImpl(this.keyspace.doExecute(new KeyspaceOperationCallback<Void>(){

            @Override
            public Void doInKeyspace(KeyspaceService ks) throws HectorException {
                ks.remove(MutatorImpl.this.keySerializer.toByteBuffer(key), ThriftFactory.createSuperColumnPath(cf, supercolumnName, columnName, sNameSerializer, nameSerializer));
                return null;
            }
        }));
    }

    @Override
    public <SN> MutationResult superDelete(final K key, final String cf, final SN supercolumnName, final Serializer<SN> sNameSerializer) {
        return new MutationResultImpl(this.keyspace.doExecute(new KeyspaceOperationCallback<Void>(){

            @Override
            public Void doInKeyspace(KeyspaceService ks) throws HectorException {
                ks.remove(MutatorImpl.this.keySerializer.toByteBuffer(key), ThriftFactory.createSuperColumnPath(cf, supercolumnName, sNameSerializer));
                return null;
            }
        }));
    }

    @Override
    public <SN, N, V> Mutator<K> addSubDelete(K key, String cf, HSuperColumn<SN, N, V> sc) {
        return this.addSubDelete(key, cf, sc, this.keyspace.createClock());
    }

    @Override
    public <SN, N, V> Mutator<K> addSubDelete(K key, String cf, HSuperColumn<SN, N, V> sc, long clock) {
        Deletion d = new Deletion().setTimestamp(clock);
        if (sc.getColumns() != null) {
            SlicePredicate pred = new SlicePredicate();
            for (HColumn<N, V> col : sc.getColumns()) {
                pred.addToColumn_names(col.getNameSerializer().toByteBuffer(col.getName()));
            }
            d.setPredicate(pred);
        }
        d.setSuper_column(sc.getNameByteBuffer());
        this.getPendingMutations().addDeletion(key, Arrays.asList(cf), d);
        return this;
    }

    @Override
    public <N, V> Mutator<K> addInsertion(K key, String cf, HColumn<N, V> c) {
        this.getPendingMutations().addInsertion(key, Arrays.asList(cf), ((HColumnImpl)c).toThrift());
        return this;
    }

    @Override
    public <SN, N, V> Mutator<K> addInsertion(K key, String cf, HSuperColumn<SN, N, V> sc) {
        this.getPendingMutations().addSuperInsertion(key, Arrays.asList(cf), ((HSuperColumnImpl)sc).toThrift());
        return this;
    }

    @Override
    public <N> Mutator<K> addDeletion(K key, String cf, N columnName, Serializer<N> nameSerializer) {
        this.addDeletion(key, cf, columnName, nameSerializer, this.keyspace.createClock());
        return this;
    }

    @Override
    public <N> Mutator<K> addDeletion(K key, String cf) {
        this.addDeletion(key, cf, null, null, this.keyspace.createClock());
        return this;
    }

    @Override
    public <N> Mutator<K> addDeletion(K key, String cf, long clock) {
        this.addDeletion(key, cf, null, null, clock);
        return this;
    }

    @Override
    public <N> Mutator<K> addDeletion(Iterable<K> keys, String cf) {
        return this.addDeletion(keys, cf, this.keyspace.createClock());
    }

    @Override
    public <N> Mutator<K> addDeletion(Iterable<K> keys, String cf, long clock) {
        for (K key : keys) {
            this.addDeletion(key, cf, null, null, clock);
        }
        return this;
    }

    @Override
    public <N> Mutator<K> addDeletion(K key, String cf, N columnName, Serializer<N> nameSerializer, long clock) {
        Deletion d;
        if (columnName != null) {
            SlicePredicate sp = new SlicePredicate();
            sp.addToColumn_names(nameSerializer.toByteBuffer(columnName));
            d = new Deletion().setTimestamp(clock).setPredicate(sp);
        } else {
            d = new Deletion().setTimestamp(clock);
        }
        this.getPendingMutations().addDeletion(key, Arrays.asList(cf), d);
        return this;
    }

    @Override
    public MutationResult execute() {
        if (this.pendingMutations == null || this.pendingMutations.isEmpty()) {
            return new MutationResultImpl(true, 0L, null);
        }
        final BatchMutation<K> mutations = this.pendingMutations.makeCopy();
        this.pendingMutations = null;
        return new MutationResultImpl(this.keyspace.doExecuteOperation(new Operation<Void>(OperationType.WRITE){

            @Override
            public Void execute(Cassandra.Client cassandra) throws Exception {
                cassandra.batch_mutate(mutations.getMutationMap(), ThriftConverter.consistencyLevel(this.consistencyLevelPolicy.get(this.operationType)));
                return null;
            }
        }));
    }

    @Override
    public Mutator<K> discardPendingMutations() {
        this.pendingMutations = null;
        return this;
    }

    public String toString() {
        return "Mutator(" + this.keyspace.toString() + ")";
    }

    @Override
    public int getPendingMutationCount() {
        return this.getPendingMutations().getSize();
    }

    private BatchMutation<K> getPendingMutations() {
        if (this.pendingMutations == null) {
            this.pendingMutations = new BatchMutation<K>(this.keySerializer, this.sizeHint);
        }
        return this.pendingMutations;
    }

    @Override
    public <N> MutationResult insertCounter(K key, String cf, HCounterColumn<N> c) {
        this.addCounter(key, cf, c);
        return this.execute();
    }

    @Override
    public <N> MutationResult incrementCounter(K key, String cf, N columnName, long increment) {
        return this.insertCounter(key, cf, new HCounterColumnImpl<N>(columnName, increment, TypeInferringSerializer.get()));
    }

    @Override
    public <N> MutationResult decrementCounter(K key, String cf, N columnName, long increment) {
        return this.incrementCounter(key, cf, columnName, increment * -1L);
    }

    @Override
    public <SN, N> MutationResult insertCounter(K key, String cf, HCounterSuperColumn<SN, N> superColumn) {
        this.addCounter(key, cf, superColumn);
        return this.execute();
    }

    @Override
    public <N> MutationResult deleteCounter(K key, String cf, N counterColumnName, Serializer<N> nameSerializer) {
        this.addCounterDeletion(key, cf, counterColumnName, nameSerializer);
        return this.execute();
    }

    @Override
    public <SN, N> MutationResult subDeleteCounter(K key, String cf, SN supercolumnName, N columnName, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer) {
        this.addCounterSubDeletion(key, cf, new HCounterSuperColumnImpl<SN, N>(sNameSerializer, nameSerializer).setName(supercolumnName).addSubCounterColumn(new HCounterColumnImpl<N>(nameSerializer)));
        return this.execute();
    }

    @Override
    public <N> Mutator<K> addCounter(K key, String cf, HCounterColumn<N> c) {
        this.getPendingMutations().addCounterInsertion(key, Arrays.asList(cf), ((HCounterColumnImpl)c).toThrift());
        return this;
    }

    @Override
    public <SN, N> Mutator<K> addCounter(K key, String cf, HCounterSuperColumn<SN, N> sc) {
        this.getPendingMutations().addSuperCounterInsertion(key, Arrays.asList(cf), ((HCounterSuperColumnImpl)sc).toThrift());
        return this;
    }

    @Override
    public <N> Mutator<K> addCounterDeletion(K key, String cf, N counterColumnName, Serializer<N> nameSerializer) {
        Deletion d;
        if (counterColumnName != null) {
            SlicePredicate sp = new SlicePredicate();
            sp.addToColumn_names(nameSerializer.toByteBuffer(counterColumnName));
            d = new Deletion().setPredicate(sp);
        } else {
            d = new Deletion();
        }
        this.getPendingMutations().addDeletion(key, Arrays.asList(cf), d);
        return this;
    }

    @Override
    public <N> Mutator<K> addCounterDeletion(K key, String cf) {
        this.getPendingMutations().addDeletion(key, Arrays.asList(cf), new Deletion());
        return this;
    }

    @Override
    public <SN, N> Mutator<K> addCounterSubDeletion(K key, String cf, HCounterSuperColumn<SN, N> sc) {
        Deletion d = new Deletion();
        if (sc.getColumns() != null) {
            SlicePredicate pred = new SlicePredicate();
            for (HCounterColumn<N> col : sc.getColumns()) {
                pred.addToColumn_names(col.getNameSerializer().toByteBuffer(col.getName()));
            }
            d.setPredicate(pred);
        }
        d.setSuper_column(sc.getNameByteBuffer());
        this.getPendingMutations().addDeletion(key, Arrays.asList(cf), d);
        return this;
    }

    @Override
    public <SN, N> Mutator<K> addSubDelete(K key, String cf, SN sColumnName, N columnName, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer) {
        return this.addSubDelete(key, cf, sColumnName, columnName, sNameSerializer, nameSerializer, this.keyspace.createClock());
    }

    @Override
    public <SN, N> Mutator<K> addSubDelete(K key, String cf, SN sColumnName, N columnName, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, long clock) {
        Deletion d = new Deletion().setTimestamp(clock);
        SlicePredicate predicate = new SlicePredicate();
        predicate.addToColumn_names(nameSerializer.toByteBuffer(columnName));
        d.setPredicate(predicate);
        d.setSuper_column(sNameSerializer.toByteBuffer(sColumnName));
        this.getPendingMutations().addDeletion(key, Arrays.asList(cf), d);
        return this;
    }

    @Override
    public <SN> Mutator<K> addSuperDelete(K key, String cf, SN sColumnName, Serializer<SN> sNameSerializer) {
        Deletion d = new Deletion().setTimestamp(this.keyspace.createClock());
        d.setSuper_column(sNameSerializer.toByteBuffer(sColumnName));
        this.getPendingMutations().addDeletion(key, Arrays.asList(cf), d);
        return this;
    }
}

