/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model;

import hector.me.prettyprint.cassandra.model.ColumnSliceImpl;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.ColumnSlice;
import hector.me.prettyprint.hector.api.beans.Row;
import java.util.List;
import org.apache.cassandra.thrift.Column;

public final class RowImpl<K, N, V>
implements Row<K, N, V> {
    private final K rowKey;
    private final ColumnSlice<N, V> columnSlice;

    RowImpl(K k, List<Column> columns, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        Assert.noneNull(k, columns, nameSerializer, valueSerializer);
        this.rowKey = k;
        this.columnSlice = new ColumnSliceImpl<N, V>(columns, nameSerializer, valueSerializer);
    }

    @Override
    public K getKey() {
        return this.rowKey;
    }

    @Override
    public ColumnSlice<N, V> getColumnSlice() {
        return this.columnSlice;
    }

    public String toString() {
        return "Row(" + this.rowKey + "," + this.columnSlice + ")";
    }
}

