/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model;

import hector.me.prettyprint.cassandra.model.RowImpl;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.Row;
import hector.me.prettyprint.hector.api.beans.Rows;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Column;

public class RowsImpl<K, N, V>
implements Rows<K, N, V> {
    protected final Map<K, Row<K, N, V>> rows;

    public RowsImpl(Map<K, List<Column>> thriftRet, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        Assert.noneNull(thriftRet, nameSerializer, valueSerializer);
        this.rows = new LinkedHashMap<K, Row<K, N, V>>(thriftRet.size());
        for (Map.Entry<K, List<Column>> entry : thriftRet.entrySet()) {
            this.rows.put(entry.getKey(), new RowImpl<K, N, V>(entry.getKey(), entry.getValue(), nameSerializer, valueSerializer));
        }
    }

    protected RowsImpl() {
        this.rows = new HashMap<K, Row<K, N, V>>();
    }

    @Override
    public Row<K, N, V> getByKey(K key) {
        return this.rows.get(key);
    }

    @Override
    public int getCount() {
        return this.rows.size();
    }

    @Override
    public Iterator<Row<K, N, V>> iterator() {
        return this.rows.values().iterator();
    }

    public String toString() {
        return "Rows(" + this.rows + ")";
    }
}

