/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model.thrift;

import hector.me.prettyprint.cassandra.model.AbstractColumnQuery;
import hector.me.prettyprint.cassandra.model.HColumnImpl;
import hector.me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import hector.me.prettyprint.cassandra.model.QueryResultImpl;
import hector.me.prettyprint.cassandra.model.thrift.ThriftFactory;
import hector.me.prettyprint.cassandra.serializers.StringSerializer;
import hector.me.prettyprint.cassandra.serializers.TypeInferringSerializer;
import hector.me.prettyprint.cassandra.service.KeyspaceService;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.HColumn;
import hector.me.prettyprint.hector.api.exceptions.HNotFoundException;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.query.ColumnQuery;
import hector.me.prettyprint.hector.api.query.QueryResult;
import org.apache.cassandra.thrift.Column;

public class ThriftColumnQuery<K, N, V>
extends AbstractColumnQuery<K, N, V>
implements ColumnQuery<K, N, V> {
    public ThriftColumnQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        super(keyspace, keySerializer, nameSerializer, valueSerializer);
    }

    public ThriftColumnQuery(Keyspace keyspace, Serializer<V> valueSerializer) {
        super(keyspace, TypeInferringSerializer.get(), TypeInferringSerializer.get(), valueSerializer);
    }

    public ThriftColumnQuery(Keyspace keyspaceOperator) {
        super(keyspaceOperator, TypeInferringSerializer.get(), TypeInferringSerializer.get(), StringSerializer.get());
    }

    @Override
    public QueryResult<HColumn<N, V>> execute() {
        return new QueryResultImpl<HColumn<N, V>>(this.keyspace.doExecute(new KeyspaceOperationCallback<HColumn<N, V>>(){

            @Override
            public HColumn<N, V> doInKeyspace(KeyspaceService ks) throws HectorException {
                try {
                    Column thriftColumn = ks.getColumn(ThriftColumnQuery.this.keySerializer.toByteBuffer(ThriftColumnQuery.this.key), ThriftFactory.createColumnPath(ThriftColumnQuery.this.columnFamilyName, ThriftColumnQuery.this.name, ThriftColumnQuery.this.columnNameSerializer));
                    return new HColumnImpl(thriftColumn, ThriftColumnQuery.this.columnNameSerializer, ThriftColumnQuery.this.valueSerializer);
                }
                catch (HNotFoundException e) {
                    return null;
                }
            }
        }), this);
    }
}

