/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model.thrift;

import hector.me.prettyprint.cassandra.model.AbstractBasicQuery;
import hector.me.prettyprint.cassandra.model.HCounterColumnImpl;
import hector.me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import hector.me.prettyprint.cassandra.model.QueryResultImpl;
import hector.me.prettyprint.cassandra.model.thrift.ThriftFactory;
import hector.me.prettyprint.cassandra.serializers.TypeInferringSerializer;
import hector.me.prettyprint.cassandra.service.KeyspaceService;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.HCounterColumn;
import hector.me.prettyprint.hector.api.exceptions.HNotFoundException;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.query.CounterQuery;
import hector.me.prettyprint.hector.api.query.QueryResult;
import org.apache.cassandra.thrift.CounterColumn;

public class ThriftCounterColumnQuery<K, N>
extends AbstractBasicQuery<K, N, HCounterColumn<N>>
implements CounterQuery<K, N> {
    protected K key;
    protected N name;

    public ThriftCounterColumnQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer) {
        super(keyspace, keySerializer, nameSerializer);
    }

    public ThriftCounterColumnQuery(Keyspace keyspace) {
        super(keyspace, TypeInferringSerializer.get(), TypeInferringSerializer.get());
    }

    @Override
    public CounterQuery<K, N> setKey(K key) {
        this.key = key;
        return this;
    }

    @Override
    public CounterQuery<K, N> setName(N name) {
        this.name = name;
        return this;
    }

    @Override
    public CounterQuery<K, N> setColumnFamily(String cf) {
        return (CounterQuery)super.setColumnFamily(cf);
    }

    @Override
    public QueryResult<HCounterColumn<N>> execute() {
        return new QueryResultImpl<HCounterColumn<N>>(this.keyspace.doExecute(new KeyspaceOperationCallback<HCounterColumn<N>>(){

            @Override
            public HCounterColumn<N> doInKeyspace(KeyspaceService ks) throws HectorException {
                try {
                    CounterColumn thriftCounter = ks.getCounter(ThriftCounterColumnQuery.this.keySerializer.toByteBuffer(ThriftCounterColumnQuery.this.key), ThriftFactory.createColumnPath(ThriftCounterColumnQuery.this.columnFamilyName, ThriftCounterColumnQuery.this.name, ThriftCounterColumnQuery.this.columnNameSerializer));
                    return new HCounterColumnImpl(thriftCounter, ThriftCounterColumnQuery.this.columnNameSerializer);
                }
                catch (HNotFoundException e) {
                    return null;
                }
            }
        }), this);
    }
}

