/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model.thrift;

import hector.me.prettyprint.cassandra.model.AbstractSliceQuery;
import hector.me.prettyprint.cassandra.model.CounterRowsImpl;
import hector.me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import hector.me.prettyprint.cassandra.model.QueryResultImpl;
import hector.me.prettyprint.cassandra.serializers.LongSerializer;
import hector.me.prettyprint.cassandra.service.KeyspaceService;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.CounterRows;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.query.MultigetSliceCounterQuery;
import hector.me.prettyprint.hector.api.query.QueryResult;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.cassandra.thrift.ColumnParent;

public final class ThriftMultigetSliceCounterQuery<K, N>
extends AbstractSliceQuery<K, N, Long, CounterRows<K, N>>
implements MultigetSliceCounterQuery<K, N> {
    private Iterable<K> keys;

    public ThriftMultigetSliceCounterQuery(Keyspace k, Serializer<K> keySerializer, Serializer<N> nameSerializer) {
        super(k, keySerializer, nameSerializer, LongSerializer.get());
    }

    @Override
    public MultigetSliceCounterQuery<K, N> setKeys(K ... keys) {
        this.keys = Arrays.asList(keys);
        return this;
    }

    @Override
    public MultigetSliceCounterQuery<K, N> setKeys(Iterable<K> keys) {
        this.keys = keys;
        return this;
    }

    @Override
    public QueryResult<CounterRows<K, N>> execute() {
        Assert.notNull(this.columnFamilyName, "columnFamilyName can't be null");
        Assert.notNull(this.keys, "keys can't be null");
        return new QueryResultImpl<CounterRows<K, N>>(this.keyspace.doExecute(new KeyspaceOperationCallback<CounterRows<K, N>>(){

            @Override
            public CounterRows<K, N> doInKeyspace(KeyspaceService ks) throws HectorException {
                ArrayList<ByteBuffer> keysList = new ArrayList<ByteBuffer>();
                for (Object k : ThriftMultigetSliceCounterQuery.this.keys) {
                    keysList.add(ThriftMultigetSliceCounterQuery.this.keySerializer.toByteBuffer(k));
                }
                ColumnParent columnParent = new ColumnParent(ThriftMultigetSliceCounterQuery.this.columnFamilyName);
                Map thriftRet = ThriftMultigetSliceCounterQuery.this.keySerializer.fromBytesMap(ks.multigetCounterSlice(keysList, columnParent, ThriftMultigetSliceCounterQuery.this.getPredicate()));
                return new CounterRowsImpl(thriftRet, ThriftMultigetSliceCounterQuery.this.columnNameSerializer);
            }
        }), this);
    }

    public String toString() {
        return "MultigetSliceQuery(" + this.keys + "," + super.toStringInternal() + ")";
    }

    @Override
    public MultigetSliceCounterQuery<K, N> setColumnNames(N ... columnNames) {
        return (MultigetSliceCounterQuery)super.setColumnNames(columnNames);
    }

    @Override
    public MultigetSliceCounterQuery<K, N> setRange(N start, N finish, boolean reversed, int count) {
        return (MultigetSliceCounterQuery)super.setRange(start, finish, reversed, count);
    }

    @Override
    public MultigetSliceCounterQuery<K, N> setColumnFamily(String cf) {
        return (MultigetSliceCounterQuery)super.setColumnFamily(cf);
    }
}

