/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model.thrift;

import hector.me.prettyprint.cassandra.model.AbstractSliceQuery;
import hector.me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import hector.me.prettyprint.cassandra.model.QueryResultImpl;
import hector.me.prettyprint.cassandra.model.RowsImpl;
import hector.me.prettyprint.cassandra.service.KeyspaceService;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.Rows;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.query.MultigetSliceQuery;
import hector.me.prettyprint.hector.api.query.QueryResult;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.cassandra.thrift.ColumnParent;

public final class ThriftMultigetSliceQuery<K, N, V>
extends AbstractSliceQuery<K, N, V, Rows<K, N, V>>
implements MultigetSliceQuery<K, N, V> {
    private Iterable<K> keys;

    public ThriftMultigetSliceQuery(Keyspace k, Serializer<K> keySerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        super(k, keySerializer, nameSerializer, valueSerializer);
    }

    @Override
    public MultigetSliceQuery<K, N, V> setKeys(K ... keys) {
        this.keys = Arrays.asList(keys);
        return this;
    }

    @Override
    public MultigetSliceQuery<K, N, V> setKeys(Iterable<K> keys) {
        this.keys = keys;
        return this;
    }

    @Override
    public QueryResult<Rows<K, N, V>> execute() {
        Assert.notNull(this.columnFamilyName, "columnFamilyName can't be null");
        Assert.notNull(this.keys, "keys can't be null");
        return new QueryResultImpl<Rows<K, N, V>>(this.keyspace.doExecute(new KeyspaceOperationCallback<Rows<K, N, V>>(){

            @Override
            public Rows<K, N, V> doInKeyspace(KeyspaceService ks) throws HectorException {
                ArrayList<ByteBuffer> keysList = new ArrayList<ByteBuffer>();
                for (Object k : ThriftMultigetSliceQuery.this.keys) {
                    if (k == null) continue;
                    keysList.add(ThriftMultigetSliceQuery.this.keySerializer.toByteBuffer(k));
                }
                ColumnParent columnParent = new ColumnParent(ThriftMultigetSliceQuery.this.columnFamilyName);
                Map thriftRet = ThriftMultigetSliceQuery.this.keySerializer.fromBytesMap(ks.multigetSlice(keysList, columnParent, ThriftMultigetSliceQuery.this.getPredicate()));
                return new RowsImpl(thriftRet, ThriftMultigetSliceQuery.this.columnNameSerializer, ThriftMultigetSliceQuery.this.valueSerializer);
            }
        }), this);
    }

    public String toString() {
        return "MultigetSliceQuery(" + this.keys + "," + super.toStringInternal() + ")";
    }

    @Override
    public MultigetSliceQuery<K, N, V> setColumnNames(N ... columnNames) {
        return (MultigetSliceQuery)super.setColumnNames(columnNames);
    }

    @Override
    public MultigetSliceQuery<K, N, V> setRange(N start, N finish, boolean reversed, int count) {
        return (MultigetSliceQuery)super.setRange(start, finish, reversed, count);
    }

    @Override
    public MultigetSliceQuery<K, N, V> setColumnFamily(String cf) {
        return (MultigetSliceQuery)super.setColumnFamily(cf);
    }
}

