/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model.thrift;

import hector.me.prettyprint.cassandra.model.AbstractSliceQuery;
import hector.me.prettyprint.cassandra.model.CounterSuperRowsImpl;
import hector.me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import hector.me.prettyprint.cassandra.model.QueryResultImpl;
import hector.me.prettyprint.cassandra.serializers.LongSerializer;
import hector.me.prettyprint.cassandra.service.KeyspaceService;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.CounterSuperRows;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.query.MultigetSuperSliceCounterQuery;
import hector.me.prettyprint.hector.api.query.QueryResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.cassandra.thrift.ColumnParent;

public final class ThriftMultigetSuperSliceCounterQuery<K, SN, N>
extends AbstractSliceQuery<K, SN, Long, CounterSuperRows<K, SN, N>>
implements MultigetSuperSliceCounterQuery<K, SN, N> {
    private Collection<K> keys;
    private final Serializer<N> nameSerializer;

    public ThriftMultigetSuperSliceCounterQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer) {
        super(keyspace, keySerializer, sNameSerializer, LongSerializer.get());
        Assert.notNull(nameSerializer, "nameSerializer can't be null");
        this.nameSerializer = nameSerializer;
    }

    @Override
    public MultigetSuperSliceCounterQuery<K, SN, N> setKeys(K ... keys) {
        this.keys = Arrays.asList(keys);
        return this;
    }

    @Override
    public MultigetSuperSliceCounterQuery<K, SN, N> setKeys(Collection<K> keys) {
        this.keys = keys;
        return this;
    }

    @Override
    public QueryResult<CounterSuperRows<K, SN, N>> execute() {
        return new QueryResultImpl<CounterSuperRows<K, SN, N>>(this.keyspace.doExecute(new KeyspaceOperationCallback<CounterSuperRows<K, SN, N>>(){

            @Override
            public CounterSuperRows<K, SN, N> doInKeyspace(KeyspaceService ks) throws HectorException {
                ArrayList keysList = new ArrayList();
                keysList.addAll(ThriftMultigetSuperSliceCounterQuery.this.keys);
                ColumnParent columnParent = new ColumnParent(ThriftMultigetSuperSliceCounterQuery.this.columnFamilyName);
                Map thriftRet = ThriftMultigetSuperSliceCounterQuery.this.keySerializer.fromBytesMap(ks.multigetCounterSuperSlice(ThriftMultigetSuperSliceCounterQuery.this.keySerializer.toBytesList(keysList), columnParent, ThriftMultigetSuperSliceCounterQuery.this.getPredicate()));
                return new CounterSuperRowsImpl(thriftRet, ThriftMultigetSuperSliceCounterQuery.this.keySerializer, ThriftMultigetSuperSliceCounterQuery.this.columnNameSerializer, ThriftMultigetSuperSliceCounterQuery.this.nameSerializer);
            }
        }), this);
    }

    public String toString() {
        return "MultigetSuperSliceQuery(" + this.keys + "," + super.toStringInternal() + ")";
    }

    @Override
    public MultigetSuperSliceCounterQuery<K, SN, N> setRange(SN start, SN finish, boolean reversed, int count) {
        return (MultigetSuperSliceCounterQuery)super.setRange(start, finish, reversed, count);
    }

    @Override
    public MultigetSuperSliceCounterQuery<K, SN, N> setColumnNames(SN ... columnNames) {
        return (MultigetSuperSliceCounterQuery)super.setColumnNames(columnNames);
    }

    @Override
    public MultigetSuperSliceCounterQuery<K, SN, N> setColumnNames(Collection<SN> columnNames) {
        return (MultigetSuperSliceCounterQuery)super.setColumnNames(columnNames);
    }

    @Override
    public MultigetSuperSliceCounterQuery<K, SN, N> setColumnFamily(String cf) {
        return (MultigetSuperSliceCounterQuery)super.setColumnFamily(cf);
    }
}

