/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model.thrift;

import hector.me.prettyprint.cassandra.model.AbstractSliceQuery;
import hector.me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import hector.me.prettyprint.cassandra.model.QueryResultImpl;
import hector.me.prettyprint.cassandra.model.SuperRowsImpl;
import hector.me.prettyprint.cassandra.service.KeyspaceService;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.SuperRows;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.query.MultigetSuperSliceQuery;
import hector.me.prettyprint.hector.api.query.QueryResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.cassandra.thrift.ColumnParent;

public final class ThriftMultigetSuperSliceQuery<K, SN, N, V>
extends AbstractSliceQuery<K, SN, V, SuperRows<K, SN, N, V>>
implements MultigetSuperSliceQuery<K, SN, N, V> {
    private Collection<K> keys;
    private final Serializer<N> nameSerializer;

    public ThriftMultigetSuperSliceQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        super(keyspace, keySerializer, sNameSerializer, valueSerializer);
        Assert.notNull(nameSerializer, "nameSerializer can't be null");
        this.nameSerializer = nameSerializer;
    }

    @Override
    public MultigetSuperSliceQuery<K, SN, N, V> setKeys(K ... keys) {
        this.keys = Arrays.asList(keys);
        return this;
    }

    @Override
    public MultigetSuperSliceQuery<K, SN, N, V> setKeys(Collection<K> keys) {
        this.keys = keys;
        return this;
    }

    @Override
    public QueryResult<SuperRows<K, SN, N, V>> execute() {
        return new QueryResultImpl<SuperRows<K, SN, N, V>>(this.keyspace.doExecute(new KeyspaceOperationCallback<SuperRows<K, SN, N, V>>(){

            @Override
            public SuperRows<K, SN, N, V> doInKeyspace(KeyspaceService ks) throws HectorException {
                ArrayList keysList = new ArrayList();
                keysList.addAll(ThriftMultigetSuperSliceQuery.this.keys);
                ColumnParent columnParent = new ColumnParent(ThriftMultigetSuperSliceQuery.this.columnFamilyName);
                Map thriftRet = ThriftMultigetSuperSliceQuery.this.keySerializer.fromBytesMap(ks.multigetSuperSlice(ThriftMultigetSuperSliceQuery.this.keySerializer.toBytesList(keysList), columnParent, ThriftMultigetSuperSliceQuery.this.getPredicate()));
                return new SuperRowsImpl(thriftRet, ThriftMultigetSuperSliceQuery.this.keySerializer, ThriftMultigetSuperSliceQuery.this.columnNameSerializer, ThriftMultigetSuperSliceQuery.this.nameSerializer, ThriftMultigetSuperSliceQuery.this.valueSerializer);
            }
        }), this);
    }

    public String toString() {
        return "MultigetSuperSliceQuery(" + this.keys + "," + super.toStringInternal() + ")";
    }

    @Override
    public MultigetSuperSliceQuery<K, SN, N, V> setRange(SN start, SN finish, boolean reversed, int count) {
        return (MultigetSuperSliceQuery)super.setRange(start, finish, reversed, count);
    }

    @Override
    public MultigetSuperSliceQuery<K, SN, N, V> setColumnNames(SN ... columnNames) {
        return (MultigetSuperSliceQuery)super.setColumnNames(columnNames);
    }

    @Override
    public MultigetSuperSliceQuery<K, SN, N, V> setColumnNames(Collection<SN> columnNames) {
        return (MultigetSuperSliceQuery)super.setColumnNames(columnNames);
    }

    @Override
    public MultigetSuperSliceQuery<K, SN, N, V> setColumnFamily(String cf) {
        return (MultigetSuperSliceQuery)super.setColumnFamily(cf);
    }
}

