/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model.thrift;

import hector.me.prettyprint.cassandra.model.AbstractSliceQuery;
import hector.me.prettyprint.cassandra.model.HKeyRange;
import hector.me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import hector.me.prettyprint.cassandra.model.OrderedRowsImpl;
import hector.me.prettyprint.cassandra.model.QueryResultImpl;
import hector.me.prettyprint.cassandra.service.KeyspaceService;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.OrderedRows;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.query.QueryResult;
import hector.me.prettyprint.hector.api.query.RangeSlicesQuery;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.cassandra.thrift.ColumnParent;

public final class ThriftRangeSlicesQuery<K, N, V>
extends AbstractSliceQuery<K, N, V, OrderedRows<K, N, V>>
implements RangeSlicesQuery<K, N, V> {
    private final HKeyRange<K> keyRange;

    public ThriftRangeSlicesQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        super(keyspace, keySerializer, nameSerializer, valueSerializer);
        this.keyRange = new HKeyRange<K>(keySerializer);
    }

    @Override
    public RangeSlicesQuery<K, N, V> setKeys(K start, K end) {
        this.keyRange.setKeys(start, end);
        return this;
    }

    @Override
    public RangeSlicesQuery<K, N, V> setRowCount(int rowCount) {
        this.keyRange.setRowCount(rowCount);
        return this;
    }

    @Override
    public QueryResult<OrderedRows<K, N, V>> execute() {
        Assert.notNull(this.columnFamilyName, "columnFamilyName can't be null");
        return new QueryResultImpl<OrderedRows<K, N, V>>(this.keyspace.doExecute(new KeyspaceOperationCallback<OrderedRows<K, N, V>>(){

            @Override
            public OrderedRows<K, N, V> doInKeyspace(KeyspaceService ks) throws HectorException {
                ColumnParent columnParent = new ColumnParent(ThriftRangeSlicesQuery.this.columnFamilyName);
                Map thriftRet = ThriftRangeSlicesQuery.this.keySerializer.fromBytesMap(ks.getRangeSlices(columnParent, ThriftRangeSlicesQuery.this.getPredicate(), ThriftRangeSlicesQuery.this.keyRange.toThrift()));
                return new OrderedRowsImpl((LinkedHashMap)thriftRet, ThriftRangeSlicesQuery.this.columnNameSerializer, ThriftRangeSlicesQuery.this.valueSerializer);
            }
        }), this);
    }

    public String toString() {
        return "RangeSlicesQuery(" + this.keyRange + super.toStringInternal() + ")";
    }

    @Override
    public RangeSlicesQuery<K, N, V> setRange(N start, N finish, boolean reversed, int count) {
        return (RangeSlicesQuery)super.setRange(start, finish, reversed, count);
    }

    @Override
    public RangeSlicesQuery<K, N, V> setColumnFamily(String cf) {
        return (RangeSlicesQuery)super.setColumnFamily(cf);
    }

    @Override
    public RangeSlicesQuery<K, N, V> setColumnNames(N ... columnNames) {
        return (RangeSlicesQuery)super.setColumnNames(columnNames);
    }

    @Override
    public ThriftRangeSlicesQuery<K, N, V> setReturnKeysOnly() {
        super.setReturnKeysOnly();
        return this;
    }
}

