/*
 * Decompiled with CFR 0.152.
 */
package hector.me.prettyprint.cassandra.model.thrift;

import hector.me.prettyprint.cassandra.model.AbstractSliceQuery;
import hector.me.prettyprint.cassandra.model.HKeyRange;
import hector.me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import hector.me.prettyprint.cassandra.model.OrderedCounterRowsImpl;
import hector.me.prettyprint.cassandra.model.QueryResultImpl;
import hector.me.prettyprint.cassandra.serializers.LongSerializer;
import hector.me.prettyprint.cassandra.service.KeyspaceService;
import hector.me.prettyprint.cassandra.utils.Assert;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.OrderedCounterRows;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import hector.me.prettyprint.hector.api.query.QueryResult;
import hector.me.prettyprint.hector.api.query.RangeSubSlicesCounterQuery;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.cassandra.thrift.ColumnParent;

public final class ThriftRangeSubSlicesCounterQuery<K, SN, N>
extends AbstractSliceQuery<K, N, Long, OrderedCounterRows<K, N>>
implements RangeSubSlicesCounterQuery<K, SN, N> {
    private final Serializer<SN> sNameSerializer;
    private final HKeyRange<K> keyRange;
    private SN superColumn;

    public ThriftRangeSubSlicesCounterQuery(Keyspace k, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer) {
        super(k, keySerializer, nameSerializer, LongSerializer.get());
        Assert.notNull(sNameSerializer, "sNameSerializer cannot be null");
        this.sNameSerializer = sNameSerializer;
        this.keyRange = new HKeyRange<K>(keySerializer);
    }

    @Override
    public RangeSubSlicesCounterQuery<K, SN, N> setKeys(K start, K end) {
        this.keyRange.setKeys(start, end);
        return this;
    }

    @Override
    public RangeSubSlicesCounterQuery<K, SN, N> setRowCount(int rowCount) {
        this.keyRange.setRowCount(rowCount);
        return this;
    }

    @Override
    public RangeSubSlicesCounterQuery<K, SN, N> setSuperColumn(SN sc) {
        Assert.notNull(sc, "sc can't be null");
        this.superColumn = sc;
        return this;
    }

    @Override
    public QueryResult<OrderedCounterRows<K, N>> execute() {
        Assert.notNull(this.columnFamilyName, "columnFamilyName can't be null");
        Assert.notNull(this.superColumn, "superColumn cannot be null");
        return new QueryResultImpl<OrderedCounterRows<K, N>>(this.keyspace.doExecute(new KeyspaceOperationCallback<OrderedCounterRows<K, N>>(){

            @Override
            public OrderedCounterRows<K, N> doInKeyspace(KeyspaceService ks) throws HectorException {
                ColumnParent columnParent = new ColumnParent(ThriftRangeSubSlicesCounterQuery.this.columnFamilyName);
                columnParent.setSuper_column(ThriftRangeSubSlicesCounterQuery.this.sNameSerializer.toByteBuffer(ThriftRangeSubSlicesCounterQuery.this.superColumn));
                Map thriftRet = ThriftRangeSubSlicesCounterQuery.this.keySerializer.fromBytesMap(ks.getRangeCounterSlices(columnParent, ThriftRangeSubSlicesCounterQuery.this.getPredicate(), ThriftRangeSubSlicesCounterQuery.this.keyRange.toThrift()));
                return new OrderedCounterRowsImpl((LinkedHashMap)thriftRet, ThriftRangeSubSlicesCounterQuery.this.columnNameSerializer);
            }
        }), this);
    }

    public String toString() {
        return "RangeSubSlicesCounterQuery(" + this.keyRange + super.toStringInternal() + ")";
    }

    @Override
    public RangeSubSlicesCounterQuery<K, SN, N> setColumnNames(N ... columnNames) {
        return (RangeSubSlicesCounterQuery)super.setColumnNames(columnNames);
    }

    @Override
    public RangeSubSlicesCounterQuery<K, SN, N> setRange(N start, N finish, boolean reversed, int count) {
        return (RangeSubSlicesCounterQuery)super.setRange(start, finish, reversed, count);
    }

    @Override
    public RangeSubSlicesCounterQuery<K, SN, N> setColumnFamily(String cf) {
        return (RangeSubSlicesCounterQuery)super.setColumnFamily(cf);
    }
}

